/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.view;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.ViewInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicListViews
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/users/{userId}/views";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private String language;
    private String storeId;

    @Deprecated
    public PublicListViews(String namespace, String userId, String language, String storeId) {
        this.namespace = namespace;
        this.userId = userId;
        this.language = language;
        this.storeId = storeId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("language", this.language == null ? null : Arrays.asList(this.language));
        queryParams.put("storeId", this.storeId == null ? null : Arrays.asList(this.storeId));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public List<ViewInfo> parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<ViewInfo>>(){});
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("language", "None");
        result.put("storeId", "None");
        return result;
    }

    public static PublicListViewsBuilder builder() {
        return new PublicListViewsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public static class PublicListViewsBuilder {
        private String namespace;
        private String userId;
        private String language;
        private String storeId;

        PublicListViewsBuilder() {
        }

        public PublicListViewsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicListViewsBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public PublicListViewsBuilder language(String language) {
            this.language = language;
            return this;
        }

        public PublicListViewsBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public PublicListViews build() {
            return new PublicListViews(this.namespace, this.userId, this.language, this.storeId);
        }

        public String toString() {
            return "PublicListViews.PublicListViewsBuilder(namespace=" + this.namespace + ", userId=" + this.userId + ", language=" + this.language + ", storeId=" + this.storeId + ")";
        }
    }
}

