/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.subscription;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.BillingHistoryPagingSlicedResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class GetUserSubscriptionBillingHistories
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/users/{userId}/subscriptions/{subscriptionId}/history";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String subscriptionId;
    private String userId;
    private Boolean excludeFree;
    private Integer limit;
    private Integer offset;

    @Deprecated
    public GetUserSubscriptionBillingHistories(String namespace, String subscriptionId, String userId, Boolean excludeFree, Integer limit, Integer offset) {
        this.namespace = namespace;
        this.subscriptionId = subscriptionId;
        this.userId = userId;
        this.excludeFree = excludeFree;
        this.limit = limit;
        this.offset = offset;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.subscriptionId != null) {
            pathParams.put("subscriptionId", this.subscriptionId);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("excludeFree", this.excludeFree == null ? null : Arrays.asList(String.valueOf(this.excludeFree)));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.subscriptionId == null) {
            return false;
        }
        return this.userId != null;
    }

    public BillingHistoryPagingSlicedResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new BillingHistoryPagingSlicedResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("excludeFree", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        return result;
    }

    public static GetUserSubscriptionBillingHistoriesBuilder builder() {
        return new GetUserSubscriptionBillingHistoriesBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Boolean getExcludeFree() {
        return this.excludeFree;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setExcludeFree(Boolean excludeFree) {
        this.excludeFree = excludeFree;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public static class GetUserSubscriptionBillingHistoriesBuilder {
        private String namespace;
        private String subscriptionId;
        private String userId;
        private Boolean excludeFree;
        private Integer limit;
        private Integer offset;

        GetUserSubscriptionBillingHistoriesBuilder() {
        }

        public GetUserSubscriptionBillingHistoriesBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GetUserSubscriptionBillingHistoriesBuilder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public GetUserSubscriptionBillingHistoriesBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public GetUserSubscriptionBillingHistoriesBuilder excludeFree(Boolean excludeFree) {
            this.excludeFree = excludeFree;
            return this;
        }

        public GetUserSubscriptionBillingHistoriesBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetUserSubscriptionBillingHistoriesBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public GetUserSubscriptionBillingHistories build() {
            return new GetUserSubscriptionBillingHistories(this.namespace, this.subscriptionId, this.userId, this.excludeFree, this.limit, this.offset);
        }

        public String toString() {
            return "GetUserSubscriptionBillingHistories.GetUserSubscriptionBillingHistoriesBuilder(namespace=" + this.namespace + ", subscriptionId=" + this.subscriptionId + ", userId=" + this.userId + ", excludeFree=" + this.excludeFree + ", limit=" + this.limit + ", offset=" + this.offset + ")";
        }
    }
}

