/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.store;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.ImportStoreResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class ImportStore1
extends Operation {
    private String path = "/platform/v2/admin/namespaces/{namespace}/stores/import";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("multipart/form-data");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String storeId;
    private Boolean strictMode;
    private File file;

    @Deprecated
    public ImportStore1(String namespace, String storeId, Boolean strictMode, File file) {
        this.namespace = namespace;
        this.storeId = storeId;
        this.strictMode = strictMode;
        this.file = file;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("storeId", this.storeId == null ? null : Arrays.asList(this.storeId));
        queryParams.put("strictMode", this.strictMode == null ? null : Arrays.asList(String.valueOf(this.strictMode)));
        return queryParams;
    }

    public Map<String, Object> getFormParams() {
        HashMap<String, Object> formDataParams = new HashMap<String, Object>();
        if (this.file != null) {
            formDataParams.put("file", this.file);
        }
        return formDataParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public ImportStoreResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ImportStoreResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("storeId", "None");
        result.put("strictMode", "None");
        return result;
    }

    public static ImportStore1Builder builder() {
        return new ImportStore1Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public Boolean getStrictMode() {
        return this.strictMode;
    }

    public File getFile() {
        return this.file;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public void setStrictMode(Boolean strictMode) {
        this.strictMode = strictMode;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public static class ImportStore1Builder {
        private String namespace;
        private String storeId;
        private Boolean strictMode;
        private File file;

        ImportStore1Builder() {
        }

        public ImportStore1Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ImportStore1Builder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public ImportStore1Builder strictMode(Boolean strictMode) {
            this.strictMode = strictMode;
            return this;
        }

        public ImportStore1Builder file(File file) {
            this.file = file;
            return this;
        }

        public ImportStore1 build() {
            return new ImportStore1(this.namespace, this.storeId, this.strictMode, this.file);
        }

        public String toString() {
            return "ImportStore1.ImportStore1Builder(namespace=" + this.namespace + ", storeId=" + this.storeId + ", strictMode=" + this.strictMode + ", file=" + this.file + ")";
        }
    }
}

