/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.store;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.StoreInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class DeleteStore
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/stores/{storeId}";
    private String method = "DELETE";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String storeId;

    @Deprecated
    public DeleteStore(String namespace, String storeId) {
        this.namespace = namespace;
        this.storeId = storeId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.storeId != null) {
            pathParams.put("storeId", this.storeId);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.storeId != null;
    }

    public StoreInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new StoreInfo().createFromJson(json);
    }

    public static DeleteStoreBuilder builder() {
        return new DeleteStoreBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public static class DeleteStoreBuilder {
        private String namespace;
        private String storeId;

        DeleteStoreBuilder() {
        }

        public DeleteStoreBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public DeleteStoreBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public DeleteStore build() {
            return new DeleteStore(this.namespace, this.storeId);
        }

        public String toString() {
            return "DeleteStore.DeleteStoreBuilder(namespace=" + this.namespace + ", storeId=" + this.storeId + ")";
        }
    }
}

