/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.section;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.SectionPagingSlicedResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class QuerySections
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/sections";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String end;
    private Integer limit;
    private Integer offset;
    private String start;
    private String storeId;
    private String viewId;

    @Deprecated
    public QuerySections(String namespace, String end, Integer limit, Integer offset, String start, String storeId, String viewId) {
        this.namespace = namespace;
        this.end = end;
        this.limit = limit;
        this.offset = offset;
        this.start = start;
        this.storeId = storeId;
        this.viewId = viewId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("end", this.end == null ? null : Arrays.asList(this.end));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("start", this.start == null ? null : Arrays.asList(this.start));
        queryParams.put("storeId", this.storeId == null ? null : Arrays.asList(this.storeId));
        queryParams.put("viewId", this.viewId == null ? null : Arrays.asList(this.viewId));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public SectionPagingSlicedResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new SectionPagingSlicedResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("end", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("start", "None");
        result.put("storeId", "None");
        result.put("viewId", "None");
        return result;
    }

    public static QuerySectionsBuilder builder() {
        return new QuerySectionsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getEnd() {
        return this.end;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getStart() {
        return this.start;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public String getViewId() {
        return this.viewId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public static class QuerySectionsBuilder {
        private String namespace;
        private String end;
        private Integer limit;
        private Integer offset;
        private String start;
        private String storeId;
        private String viewId;

        QuerySectionsBuilder() {
        }

        public QuerySectionsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public QuerySectionsBuilder end(String end) {
            this.end = end;
            return this;
        }

        public QuerySectionsBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public QuerySectionsBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public QuerySectionsBuilder start(String start) {
            this.start = start;
            return this;
        }

        public QuerySectionsBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public QuerySectionsBuilder viewId(String viewId) {
            this.viewId = viewId;
            return this;
        }

        public QuerySections build() {
            return new QuerySections(this.namespace, this.end, this.limit, this.offset, this.start, this.storeId, this.viewId);
        }

        public String toString() {
            return "QuerySections.QuerySectionsBuilder(namespace=" + this.namespace + ", end=" + this.end + ", limit=" + this.limit + ", offset=" + this.offset + ", start=" + this.start + ", storeId=" + this.storeId + ", viewId=" + this.viewId + ")";
        }
    }
}

