/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.reward;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.RewardPagingSlicedResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class QueryRewards1
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/rewards/byCriteria";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String eventTopic;
    private Integer limit;
    private Integer offset;
    private List<String> sortBy;

    @Deprecated
    public QueryRewards1(String namespace, String eventTopic, Integer limit, Integer offset, List<String> sortBy) {
        this.namespace = namespace;
        this.eventTopic = eventTopic;
        this.limit = limit;
        this.offset = offset;
        this.sortBy = sortBy;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("eventTopic", this.eventTopic == null ? null : Arrays.asList(this.eventTopic));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("sortBy", this.sortBy == null ? null : this.sortBy);
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public RewardPagingSlicedResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new RewardPagingSlicedResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("eventTopic", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("sortBy", "csv");
        return result;
    }

    public static QueryRewards1Builder builder() {
        return new QueryRewards1Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getEventTopic() {
        return this.eventTopic;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public List<String> getSortBy() {
        return this.sortBy;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setEventTopic(String eventTopic) {
        this.eventTopic = eventTopic;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setSortBy(List<String> sortBy) {
        this.sortBy = sortBy;
    }

    public static class QueryRewards1Builder {
        private String namespace;
        private String eventTopic;
        private Integer limit;
        private Integer offset;
        private List<String> sortBy;

        public QueryRewards1Builder sortBy(List<String> sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public QueryRewards1Builder sortByFromEnum(List<SortBy> sortBy) {
            ArrayList<String> en = new ArrayList<String>();
            for (SortBy e : sortBy) {
                en.add(e.toString());
            }
            this.sortBy = en;
            return this;
        }

        QueryRewards1Builder() {
        }

        public QueryRewards1Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public QueryRewards1Builder eventTopic(String eventTopic) {
            this.eventTopic = eventTopic;
            return this;
        }

        public QueryRewards1Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public QueryRewards1Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public QueryRewards1 build() {
            return new QueryRewards1(this.namespace, this.eventTopic, this.limit, this.offset, this.sortBy);
        }

        public String toString() {
            return "QueryRewards1.QueryRewards1Builder(namespace=" + this.namespace + ", eventTopic=" + this.eventTopic + ", limit=" + this.limit + ", offset=" + this.offset + ", sortBy=" + this.sortBy + ")";
        }
    }

    public static enum SortBy {
        Namespace("namespace"),
        Namespaceasc("namespace:asc"),
        Namespacedesc("namespace:desc"),
        RewardCode("rewardCode"),
        RewardCodeasc("rewardCode:asc"),
        RewardCodedesc("rewardCode:desc");

        private String value;

        private SortBy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

