/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.reward;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class ImportRewards
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/rewards/import";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("multipart/form-data");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private Boolean replaceExisting;
    private File file;

    @Deprecated
    public ImportRewards(String namespace, Boolean replaceExisting, File file) {
        this.namespace = namespace;
        this.replaceExisting = replaceExisting;
        this.file = file;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("replaceExisting", this.replaceExisting == null ? null : Arrays.asList(String.valueOf(this.replaceExisting)));
        return queryParams;
    }

    public Map<String, Object> getFormParams() {
        HashMap<String, Object> formDataParams = new HashMap<String, Object>();
        if (this.file != null) {
            formDataParams.put("file", this.file);
        }
        return formDataParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.replaceExisting != null;
    }

    public void handleEmptyResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("replaceExisting", "None");
        return result;
    }

    public static ImportRewardsBuilder builder() {
        return new ImportRewardsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Boolean getReplaceExisting() {
        return this.replaceExisting;
    }

    public File getFile() {
        return this.file;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setReplaceExisting(Boolean replaceExisting) {
        this.replaceExisting = replaceExisting;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public static class ImportRewardsBuilder {
        private String namespace;
        private Boolean replaceExisting;
        private File file;

        ImportRewardsBuilder() {
        }

        public ImportRewardsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ImportRewardsBuilder replaceExisting(Boolean replaceExisting) {
            this.replaceExisting = replaceExisting;
            return this;
        }

        public ImportRewardsBuilder file(File file) {
            this.file = file;
            return this;
        }

        public ImportRewards build() {
            return new ImportRewards(this.namespace, this.replaceExisting, this.file);
        }

        public String toString() {
            return "ImportRewards.ImportRewardsBuilder(namespace=" + this.namespace + ", replaceExisting=" + this.replaceExisting + ", file=" + this.file + ")";
        }
    }
}

