/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.reward;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.RewardInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class GetRewardByCode
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/rewards/byCode";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String rewardCode;

    @Deprecated
    public GetRewardByCode(String namespace, String rewardCode) {
        this.namespace = namespace;
        this.rewardCode = rewardCode;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("rewardCode", this.rewardCode == null ? null : Arrays.asList(this.rewardCode));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.rewardCode != null;
    }

    public RewardInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new RewardInfo().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("rewardCode", "None");
        return result;
    }

    public static GetRewardByCodeBuilder builder() {
        return new GetRewardByCodeBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getRewardCode() {
        return this.rewardCode;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setRewardCode(String rewardCode) {
        this.rewardCode = rewardCode;
    }

    public static class GetRewardByCodeBuilder {
        private String namespace;
        private String rewardCode;

        GetRewardByCodeBuilder() {
        }

        public GetRewardByCodeBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GetRewardByCodeBuilder rewardCode(String rewardCode) {
            this.rewardCode = rewardCode;
            return this;
        }

        public GetRewardByCode build() {
            return new GetRewardByCode(this.namespace, this.rewardCode);
        }

        public String toString() {
            return "GetRewardByCode.GetRewardByCodeBuilder(namespace=" + this.namespace + ", rewardCode=" + this.rewardCode + ")";
        }
    }
}

