/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.revocation;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.RevocationConfigInfo;
import net.accelbyte.sdk.api.platform.models.RevocationConfigUpdate;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class UpdateRevocationConfig
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/revocation/config";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private RevocationConfigUpdate body;

    @Deprecated
    public UpdateRevocationConfig(String namespace, RevocationConfigUpdate body) {
        this.namespace = namespace;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public RevocationConfigUpdate getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public RevocationConfigInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new RevocationConfigInfo().createFromJson(json);
    }

    public static UpdateRevocationConfigBuilder builder() {
        return new UpdateRevocationConfigBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public RevocationConfigUpdate getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBody(RevocationConfigUpdate body) {
        this.body = body;
    }

    public static class UpdateRevocationConfigBuilder {
        private String namespace;
        private RevocationConfigUpdate body;

        UpdateRevocationConfigBuilder() {
        }

        public UpdateRevocationConfigBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public UpdateRevocationConfigBuilder body(RevocationConfigUpdate body) {
            this.body = body;
            return this;
        }

        public UpdateRevocationConfig build() {
            return new UpdateRevocationConfig(this.namespace, this.body);
        }

        public String toString() {
            return "UpdateRevocationConfig.UpdateRevocationConfigBuilder(namespace=" + this.namespace + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

