/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.revocation;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.RevocationHistoryPagingSlicedResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class QueryRevocationHistories
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/revocation/history";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String endTime;
    private Integer limit;
    private Integer offset;
    private String source;
    private String startTime;
    private String status;
    private String transactionId;
    private String userId;

    @Deprecated
    public QueryRevocationHistories(String namespace, String endTime, Integer limit, Integer offset, String source, String startTime, String status, String transactionId, String userId) {
        this.namespace = namespace;
        this.endTime = endTime;
        this.limit = limit;
        this.offset = offset;
        this.source = source;
        this.startTime = startTime;
        this.status = status;
        this.transactionId = transactionId;
        this.userId = userId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("endTime", this.endTime == null ? null : Arrays.asList(this.endTime));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("source", this.source == null ? null : Arrays.asList(this.source));
        queryParams.put("startTime", this.startTime == null ? null : Arrays.asList(this.startTime));
        queryParams.put("status", this.status == null ? null : Arrays.asList(this.status));
        queryParams.put("transactionId", this.transactionId == null ? null : Arrays.asList(this.transactionId));
        queryParams.put("userId", this.userId == null ? null : Arrays.asList(this.userId));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public RevocationHistoryPagingSlicedResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new RevocationHistoryPagingSlicedResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("endTime", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("source", "None");
        result.put("startTime", "None");
        result.put("status", "None");
        result.put("transactionId", "None");
        result.put("userId", "None");
        return result;
    }

    public static QueryRevocationHistoriesBuilder builder() {
        return new QueryRevocationHistoriesBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getSource() {
        return this.source;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getStatus() {
        return this.status;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public static class QueryRevocationHistoriesBuilder {
        private String namespace;
        private String endTime;
        private Integer limit;
        private Integer offset;
        private String startTime;
        private String transactionId;
        private String userId;
        private String source;
        private String status;

        public QueryRevocationHistoriesBuilder source(String source) {
            this.source = source;
            return this;
        }

        public QueryRevocationHistoriesBuilder sourceFromEnum(Source source) {
            this.source = source.toString();
            return this;
        }

        public QueryRevocationHistoriesBuilder status(String status) {
            this.status = status;
            return this;
        }

        public QueryRevocationHistoriesBuilder statusFromEnum(Status status) {
            this.status = status.toString();
            return this;
        }

        QueryRevocationHistoriesBuilder() {
        }

        public QueryRevocationHistoriesBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public QueryRevocationHistoriesBuilder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public QueryRevocationHistoriesBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public QueryRevocationHistoriesBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public QueryRevocationHistoriesBuilder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public QueryRevocationHistoriesBuilder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public QueryRevocationHistoriesBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public QueryRevocationHistories build() {
            return new QueryRevocationHistories(this.namespace, this.endTime, this.limit, this.offset, this.source, this.startTime, this.status, this.transactionId, this.userId);
        }

        public String toString() {
            return "QueryRevocationHistories.QueryRevocationHistoriesBuilder(namespace=" + this.namespace + ", endTime=" + this.endTime + ", limit=" + this.limit + ", offset=" + this.offset + ", source=" + this.source + ", startTime=" + this.startTime + ", status=" + this.status + ", transactionId=" + this.transactionId + ", userId=" + this.userId + ")";
        }
    }

    public static enum Status {
        FAIL("FAIL"),
        SUCCESS("SUCCESS");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Source {
        DLC("DLC"),
        IAP("IAP"),
        ORDER("ORDER"),
        OTHER("OTHER");

        private String value;

        private Source(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

