/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.payment_station;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.PaymentMethod;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicGetPaymentMethods
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/payment/methods";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String paymentOrderNo;

    @Deprecated
    public PublicGetPaymentMethods(String namespace, String paymentOrderNo) {
        this.namespace = namespace;
        this.paymentOrderNo = paymentOrderNo;
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("paymentOrderNo", this.paymentOrderNo == null ? null : Arrays.asList(this.paymentOrderNo));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.paymentOrderNo != null;
    }

    public List<PaymentMethod> parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<PaymentMethod>>(){});
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("paymentOrderNo", "None");
        return result;
    }

    public static PublicGetPaymentMethodsBuilder builder() {
        return new PublicGetPaymentMethodsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPaymentOrderNo() {
        return this.paymentOrderNo;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setPaymentOrderNo(String paymentOrderNo) {
        this.paymentOrderNo = paymentOrderNo;
    }

    public static class PublicGetPaymentMethodsBuilder {
        private String namespace;
        private String paymentOrderNo;

        PublicGetPaymentMethodsBuilder() {
        }

        public PublicGetPaymentMethodsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicGetPaymentMethodsBuilder paymentOrderNo(String paymentOrderNo) {
            this.paymentOrderNo = paymentOrderNo;
            return this;
        }

        public PublicGetPaymentMethods build() {
            return new PublicGetPaymentMethods(this.namespace, this.paymentOrderNo);
        }

        public String toString() {
            return "PublicGetPaymentMethods.PublicGetPaymentMethodsBuilder(namespace=" + this.namespace + ", paymentOrderNo=" + this.paymentOrderNo + ")";
        }
    }
}

