/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.payment_station;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.TaxResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class GetPaymentTaxValue
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/payment/tax";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String zipCode;
    private String paymentOrderNo;
    private String paymentProvider;

    @Deprecated
    public GetPaymentTaxValue(String namespace, String zipCode, String paymentOrderNo, String paymentProvider) {
        this.namespace = namespace;
        this.zipCode = zipCode;
        this.paymentOrderNo = paymentOrderNo;
        this.paymentProvider = paymentProvider;
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("zipCode", this.zipCode == null ? null : Arrays.asList(this.zipCode));
        queryParams.put("paymentOrderNo", this.paymentOrderNo == null ? null : Arrays.asList(this.paymentOrderNo));
        queryParams.put("paymentProvider", this.paymentProvider == null ? null : Arrays.asList(this.paymentProvider));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.paymentOrderNo == null) {
            return false;
        }
        return this.paymentProvider != null;
    }

    public TaxResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new TaxResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("zipCode", "None");
        result.put("paymentOrderNo", "None");
        result.put("paymentProvider", "None");
        return result;
    }

    public static GetPaymentTaxValueBuilder builder() {
        return new GetPaymentTaxValueBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public String getPaymentOrderNo() {
        return this.paymentOrderNo;
    }

    public String getPaymentProvider() {
        return this.paymentProvider;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public void setPaymentOrderNo(String paymentOrderNo) {
        this.paymentOrderNo = paymentOrderNo;
    }

    public void setPaymentProvider(String paymentProvider) {
        this.paymentProvider = paymentProvider;
    }

    public static class GetPaymentTaxValueBuilder {
        private String namespace;
        private String zipCode;
        private String paymentOrderNo;
        private String paymentProvider;

        public GetPaymentTaxValueBuilder paymentProvider(String paymentProvider) {
            this.paymentProvider = paymentProvider;
            return this;
        }

        public GetPaymentTaxValueBuilder paymentProviderFromEnum(PaymentProvider paymentProvider) {
            this.paymentProvider = paymentProvider.toString();
            return this;
        }

        GetPaymentTaxValueBuilder() {
        }

        public GetPaymentTaxValueBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GetPaymentTaxValueBuilder zipCode(String zipCode) {
            this.zipCode = zipCode;
            return this;
        }

        public GetPaymentTaxValueBuilder paymentOrderNo(String paymentOrderNo) {
            this.paymentOrderNo = paymentOrderNo;
            return this;
        }

        public GetPaymentTaxValue build() {
            return new GetPaymentTaxValue(this.namespace, this.zipCode, this.paymentOrderNo, this.paymentProvider);
        }

        public String toString() {
            return "GetPaymentTaxValue.GetPaymentTaxValueBuilder(namespace=" + this.namespace + ", zipCode=" + this.zipCode + ", paymentOrderNo=" + this.paymentOrderNo + ", paymentProvider=" + this.paymentProvider + ")";
        }
    }

    public static enum PaymentProvider {
        ADYEN("ADYEN"),
        ALIPAY("ALIPAY"),
        CHECKOUT("CHECKOUT"),
        PAYPAL("PAYPAL"),
        STRIPE("STRIPE"),
        WALLET("WALLET"),
        WXPAY("WXPAY"),
        XSOLLA("XSOLLA");

        private String value;

        private PaymentProvider(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

