/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.payment_config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.PayPalConfig;
import net.accelbyte.sdk.api.platform.models.TestResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class TestPayPalConfig
extends Operation {
    private String path = "/platform/admin/payment/config/merchant/paypalconfig/test";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private Boolean sandbox;
    private PayPalConfig body;

    @Deprecated
    public TestPayPalConfig(Boolean sandbox, PayPalConfig body) {
        this.sandbox = sandbox;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("sandbox", this.sandbox == null ? null : Arrays.asList(String.valueOf(this.sandbox)));
        return queryParams;
    }

    public PayPalConfig getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        return true;
    }

    public TestResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new TestResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("sandbox", "None");
        return result;
    }

    public static TestPayPalConfigBuilder builder() {
        return new TestPayPalConfigBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public Boolean getSandbox() {
        return this.sandbox;
    }

    public PayPalConfig getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setSandbox(Boolean sandbox) {
        this.sandbox = sandbox;
    }

    public void setBody(PayPalConfig body) {
        this.body = body;
    }

    public static class TestPayPalConfigBuilder {
        private Boolean sandbox;
        private PayPalConfig body;

        TestPayPalConfigBuilder() {
        }

        public TestPayPalConfigBuilder sandbox(Boolean sandbox) {
            this.sandbox = sandbox;
            return this;
        }

        public TestPayPalConfigBuilder body(PayPalConfig body) {
            this.body = body;
            return this;
        }

        public TestPayPalConfig build() {
            return new TestPayPalConfig(this.sandbox, this.body);
        }

        public String toString() {
            return "TestPayPalConfig.TestPayPalConfigBuilder(sandbox=" + this.sandbox + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

