/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.payment_config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.PaymentProviderConfigPagingSlicedResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class QueryPaymentProviderConfig
extends Operation {
    private String path = "/platform/admin/payment/config/provider";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private Integer limit;
    private String namespace;
    private Integer offset;
    private String region;

    @Deprecated
    public QueryPaymentProviderConfig(Integer limit, String namespace, Integer offset, String region) {
        this.limit = limit;
        this.namespace = namespace;
        this.offset = offset;
        this.region = region;
        this.securities.add("Bearer");
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("namespace", this.namespace == null ? null : Arrays.asList(this.namespace));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("region", this.region == null ? null : Arrays.asList(this.region));
        return queryParams;
    }

    public boolean isValid() {
        return true;
    }

    public PaymentProviderConfigPagingSlicedResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new PaymentProviderConfigPagingSlicedResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("limit", "None");
        result.put("namespace", "None");
        result.put("offset", "None");
        result.put("region", "None");
        return result;
    }

    public static QueryPaymentProviderConfigBuilder builder() {
        return new QueryPaymentProviderConfigBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getRegion() {
        return this.region;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public static class QueryPaymentProviderConfigBuilder {
        private Integer limit;
        private String namespace;
        private Integer offset;
        private String region;

        QueryPaymentProviderConfigBuilder() {
        }

        public QueryPaymentProviderConfigBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public QueryPaymentProviderConfigBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public QueryPaymentProviderConfigBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public QueryPaymentProviderConfigBuilder region(String region) {
            this.region = region;
            return this;
        }

        public QueryPaymentProviderConfig build() {
            return new QueryPaymentProviderConfig(this.limit, this.namespace, this.offset, this.region);
        }

        public String toString() {
            return "QueryPaymentProviderConfig.QueryPaymentProviderConfigBuilder(limit=" + this.limit + ", namespace=" + this.namespace + ", offset=" + this.offset + ", region=" + this.region + ")";
        }
    }
}

