/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.payment;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.PaymentNotificationPagingSlicedResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class QueryPaymentNotifications
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/payment/notifications";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String endDate;
    private String externalId;
    private Integer limit;
    private String notificationSource;
    private String notificationType;
    private Integer offset;
    private String paymentOrderNo;
    private String startDate;
    private String status;

    @Deprecated
    public QueryPaymentNotifications(String namespace, String endDate, String externalId, Integer limit, String notificationSource, String notificationType, Integer offset, String paymentOrderNo, String startDate, String status) {
        this.namespace = namespace;
        this.endDate = endDate;
        this.externalId = externalId;
        this.limit = limit;
        this.notificationSource = notificationSource;
        this.notificationType = notificationType;
        this.offset = offset;
        this.paymentOrderNo = paymentOrderNo;
        this.startDate = startDate;
        this.status = status;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("endDate", this.endDate == null ? null : Arrays.asList(this.endDate));
        queryParams.put("externalId", this.externalId == null ? null : Arrays.asList(this.externalId));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("notificationSource", this.notificationSource == null ? null : Arrays.asList(this.notificationSource));
        queryParams.put("notificationType", this.notificationType == null ? null : Arrays.asList(this.notificationType));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("paymentOrderNo", this.paymentOrderNo == null ? null : Arrays.asList(this.paymentOrderNo));
        queryParams.put("startDate", this.startDate == null ? null : Arrays.asList(this.startDate));
        queryParams.put("status", this.status == null ? null : Arrays.asList(this.status));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public PaymentNotificationPagingSlicedResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new PaymentNotificationPagingSlicedResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("endDate", "None");
        result.put("externalId", "None");
        result.put("limit", "None");
        result.put("notificationSource", "None");
        result.put("notificationType", "None");
        result.put("offset", "None");
        result.put("paymentOrderNo", "None");
        result.put("startDate", "None");
        result.put("status", "None");
        return result;
    }

    public static QueryPaymentNotificationsBuilder builder() {
        return new QueryPaymentNotificationsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getNotificationSource() {
        return this.notificationSource;
    }

    public String getNotificationType() {
        return this.notificationType;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getPaymentOrderNo() {
        return this.paymentOrderNo;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getStatus() {
        return this.status;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setNotificationSource(String notificationSource) {
        this.notificationSource = notificationSource;
    }

    public void setNotificationType(String notificationType) {
        this.notificationType = notificationType;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setPaymentOrderNo(String paymentOrderNo) {
        this.paymentOrderNo = paymentOrderNo;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public static class QueryPaymentNotificationsBuilder {
        private String namespace;
        private String endDate;
        private String externalId;
        private Integer limit;
        private String notificationType;
        private Integer offset;
        private String paymentOrderNo;
        private String startDate;
        private String notificationSource;
        private String status;

        public QueryPaymentNotificationsBuilder notificationSource(String notificationSource) {
            this.notificationSource = notificationSource;
            return this;
        }

        public QueryPaymentNotificationsBuilder notificationSourceFromEnum(NotificationSource notificationSource) {
            this.notificationSource = notificationSource.toString();
            return this;
        }

        public QueryPaymentNotificationsBuilder status(String status) {
            this.status = status;
            return this;
        }

        public QueryPaymentNotificationsBuilder statusFromEnum(Status status) {
            this.status = status.toString();
            return this;
        }

        QueryPaymentNotificationsBuilder() {
        }

        public QueryPaymentNotificationsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public QueryPaymentNotificationsBuilder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public QueryPaymentNotificationsBuilder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public QueryPaymentNotificationsBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public QueryPaymentNotificationsBuilder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        public QueryPaymentNotificationsBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public QueryPaymentNotificationsBuilder paymentOrderNo(String paymentOrderNo) {
            this.paymentOrderNo = paymentOrderNo;
            return this;
        }

        public QueryPaymentNotificationsBuilder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public QueryPaymentNotifications build() {
            return new QueryPaymentNotifications(this.namespace, this.endDate, this.externalId, this.limit, this.notificationSource, this.notificationType, this.offset, this.paymentOrderNo, this.startDate, this.status);
        }

        public String toString() {
            return "QueryPaymentNotifications.QueryPaymentNotificationsBuilder(namespace=" + this.namespace + ", endDate=" + this.endDate + ", externalId=" + this.externalId + ", limit=" + this.limit + ", notificationSource=" + this.notificationSource + ", notificationType=" + this.notificationType + ", offset=" + this.offset + ", paymentOrderNo=" + this.paymentOrderNo + ", startDate=" + this.startDate + ", status=" + this.status + ")";
        }
    }

    public static enum Status {
        ERROR("ERROR"),
        IGNORED("IGNORED"),
        PROCESSED("PROCESSED"),
        WARN("WARN");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum NotificationSource {
        ADYEN("ADYEN"),
        ALIPAY("ALIPAY"),
        CHECKOUT("CHECKOUT"),
        PAYPAL("PAYPAL"),
        STRIPE("STRIPE"),
        WALLET("WALLET"),
        WXPAY("WXPAY"),
        XSOLLA("XSOLLA");

        private String value;

        private NotificationSource(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

