/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.payment;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.PaymentOrderChargeRequest;
import net.accelbyte.sdk.api.platform.models.PaymentOrderInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class ChargePaymentOrder
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/payment/orders/{paymentOrderNo}";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String paymentOrderNo;
    private PaymentOrderChargeRequest body;

    @Deprecated
    public ChargePaymentOrder(String namespace, String paymentOrderNo, PaymentOrderChargeRequest body) {
        this.namespace = namespace;
        this.paymentOrderNo = paymentOrderNo;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.paymentOrderNo != null) {
            pathParams.put("paymentOrderNo", this.paymentOrderNo);
        }
        return pathParams;
    }

    public PaymentOrderChargeRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.paymentOrderNo != null;
    }

    public PaymentOrderInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new PaymentOrderInfo().createFromJson(json);
    }

    public static ChargePaymentOrderBuilder builder() {
        return new ChargePaymentOrderBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPaymentOrderNo() {
        return this.paymentOrderNo;
    }

    public PaymentOrderChargeRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setPaymentOrderNo(String paymentOrderNo) {
        this.paymentOrderNo = paymentOrderNo;
    }

    public void setBody(PaymentOrderChargeRequest body) {
        this.body = body;
    }

    public static class ChargePaymentOrderBuilder {
        private String namespace;
        private String paymentOrderNo;
        private PaymentOrderChargeRequest body;

        ChargePaymentOrderBuilder() {
        }

        public ChargePaymentOrderBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ChargePaymentOrderBuilder paymentOrderNo(String paymentOrderNo) {
            this.paymentOrderNo = paymentOrderNo;
            return this;
        }

        public ChargePaymentOrderBuilder body(PaymentOrderChargeRequest body) {
            this.body = body;
            return this;
        }

        public ChargePaymentOrder build() {
            return new ChargePaymentOrder(this.namespace, this.paymentOrderNo, this.body);
        }

        public String toString() {
            return "ChargePaymentOrder.ChargePaymentOrderBuilder(namespace=" + this.namespace + ", paymentOrderNo=" + this.paymentOrderNo + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

