/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.order;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.OrderInfo;
import net.accelbyte.sdk.api.platform.models.OrderRefundCreate;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class RefundOrder
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/orders/{orderNo}/refund";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String orderNo;
    private OrderRefundCreate body;

    @Deprecated
    public RefundOrder(String namespace, String orderNo, OrderRefundCreate body) {
        this.namespace = namespace;
        this.orderNo = orderNo;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.orderNo != null) {
            pathParams.put("orderNo", this.orderNo);
        }
        return pathParams;
    }

    public OrderRefundCreate getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.orderNo != null;
    }

    public OrderInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new OrderInfo().createFromJson(json);
    }

    public static RefundOrderBuilder builder() {
        return new RefundOrderBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public OrderRefundCreate getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public void setBody(OrderRefundCreate body) {
        this.body = body;
    }

    public static class RefundOrderBuilder {
        private String namespace;
        private String orderNo;
        private OrderRefundCreate body;

        RefundOrderBuilder() {
        }

        public RefundOrderBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public RefundOrderBuilder orderNo(String orderNo) {
            this.orderNo = orderNo;
            return this;
        }

        public RefundOrderBuilder body(OrderRefundCreate body) {
            this.body = body;
            return this;
        }

        public RefundOrder build() {
            return new RefundOrder(this.namespace, this.orderNo, this.body);
        }

        public String toString() {
            return "RefundOrder.RefundOrderBuilder(namespace=" + this.namespace + ", orderNo=" + this.orderNo + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

