/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.order;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.OrderPagingResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class QueryOrders
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/orders";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String endTime;
    private Integer limit;
    private Integer offset;
    private List<String> orderNos;
    private String sortBy;
    private String startTime;
    private String status;
    private Boolean withTotal;

    @Deprecated
    public QueryOrders(String namespace, String endTime, Integer limit, Integer offset, List<String> orderNos, String sortBy, String startTime, String status, Boolean withTotal) {
        this.namespace = namespace;
        this.endTime = endTime;
        this.limit = limit;
        this.offset = offset;
        this.orderNos = orderNos;
        this.sortBy = sortBy;
        this.startTime = startTime;
        this.status = status;
        this.withTotal = withTotal;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("endTime", this.endTime == null ? null : Arrays.asList(this.endTime));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("orderNos", this.orderNos == null ? null : this.orderNos);
        queryParams.put("sortBy", this.sortBy == null ? null : Arrays.asList(this.sortBy));
        queryParams.put("startTime", this.startTime == null ? null : Arrays.asList(this.startTime));
        queryParams.put("status", this.status == null ? null : Arrays.asList(this.status));
        queryParams.put("withTotal", this.withTotal == null ? null : Arrays.asList(String.valueOf(this.withTotal)));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public OrderPagingResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new OrderPagingResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("endTime", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("orderNos", "multi");
        result.put("sortBy", "None");
        result.put("startTime", "None");
        result.put("status", "None");
        result.put("withTotal", "None");
        return result;
    }

    public static QueryOrdersBuilder builder() {
        return new QueryOrdersBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public List<String> getOrderNos() {
        return this.orderNos;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getStatus() {
        return this.status;
    }

    public Boolean getWithTotal() {
        return this.withTotal;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setOrderNos(List<String> orderNos) {
        this.orderNos = orderNos;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setWithTotal(Boolean withTotal) {
        this.withTotal = withTotal;
    }

    public static class QueryOrdersBuilder {
        private String namespace;
        private String endTime;
        private Integer limit;
        private Integer offset;
        private List<String> orderNos;
        private String sortBy;
        private String startTime;
        private Boolean withTotal;
        private String status;

        public QueryOrdersBuilder status(String status) {
            this.status = status;
            return this;
        }

        public QueryOrdersBuilder statusFromEnum(Status status) {
            this.status = status.toString();
            return this;
        }

        QueryOrdersBuilder() {
        }

        public QueryOrdersBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public QueryOrdersBuilder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public QueryOrdersBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public QueryOrdersBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public QueryOrdersBuilder orderNos(List<String> orderNos) {
            this.orderNos = orderNos;
            return this;
        }

        public QueryOrdersBuilder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public QueryOrdersBuilder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public QueryOrdersBuilder withTotal(Boolean withTotal) {
            this.withTotal = withTotal;
            return this;
        }

        public QueryOrders build() {
            return new QueryOrders(this.namespace, this.endTime, this.limit, this.offset, this.orderNos, this.sortBy, this.startTime, this.status, this.withTotal);
        }

        public String toString() {
            return "QueryOrders.QueryOrdersBuilder(namespace=" + this.namespace + ", endTime=" + this.endTime + ", limit=" + this.limit + ", offset=" + this.offset + ", orderNos=" + this.orderNos + ", sortBy=" + this.sortBy + ", startTime=" + this.startTime + ", status=" + this.status + ", withTotal=" + this.withTotal + ")";
        }
    }

    public static enum Status {
        CHARGEBACK("CHARGEBACK"),
        CHARGEBACKREVERSED("CHARGEBACK_REVERSED"),
        CHARGED("CHARGED"),
        CLOSED("CLOSED"),
        DELETED("DELETED"),
        FULFILLED("FULFILLED"),
        FULFILLFAILED("FULFILL_FAILED"),
        INIT("INIT"),
        REFUNDED("REFUNDED"),
        REFUNDING("REFUNDING"),
        REFUNDFAILED("REFUND_FAILED");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

