/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.order;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.OrderPagingSlicedResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicQueryUserOrders
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/users/{userId}/orders";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private String itemId;
    private Integer limit;
    private Integer offset;
    private String status;

    @Deprecated
    public PublicQueryUserOrders(String namespace, String userId, String itemId, Integer limit, Integer offset, String status) {
        this.namespace = namespace;
        this.userId = userId;
        this.itemId = itemId;
        this.limit = limit;
        this.offset = offset;
        this.status = status;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("itemId", this.itemId == null ? null : Arrays.asList(this.itemId));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("status", this.status == null ? null : Arrays.asList(this.status));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public OrderPagingSlicedResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new OrderPagingSlicedResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("itemId", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("status", "None");
        return result;
    }

    public static PublicQueryUserOrdersBuilder builder() {
        return new PublicQueryUserOrdersBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getItemId() {
        return this.itemId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getStatus() {
        return this.status;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public static class PublicQueryUserOrdersBuilder {
        private String namespace;
        private String userId;
        private String itemId;
        private Integer limit;
        private Integer offset;
        private String status;

        public PublicQueryUserOrdersBuilder status(String status) {
            this.status = status;
            return this;
        }

        public PublicQueryUserOrdersBuilder statusFromEnum(Status status) {
            this.status = status.toString();
            return this;
        }

        PublicQueryUserOrdersBuilder() {
        }

        public PublicQueryUserOrdersBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicQueryUserOrdersBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public PublicQueryUserOrdersBuilder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public PublicQueryUserOrdersBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public PublicQueryUserOrdersBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public PublicQueryUserOrders build() {
            return new PublicQueryUserOrders(this.namespace, this.userId, this.itemId, this.limit, this.offset, this.status);
        }

        public String toString() {
            return "PublicQueryUserOrders.PublicQueryUserOrdersBuilder(namespace=" + this.namespace + ", userId=" + this.userId + ", itemId=" + this.itemId + ", limit=" + this.limit + ", offset=" + this.offset + ", status=" + this.status + ")";
        }
    }

    public static enum Status {
        CHARGEBACK("CHARGEBACK"),
        CHARGEBACKREVERSED("CHARGEBACK_REVERSED"),
        CHARGED("CHARGED"),
        CLOSED("CLOSED"),
        DELETED("DELETED"),
        FULFILLED("FULFILLED"),
        FULFILLFAILED("FULFILL_FAILED"),
        INIT("INIT"),
        REFUNDED("REFUNDED"),
        REFUNDING("REFUNDING"),
        REFUNDFAILED("REFUND_FAILED");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

