/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.order;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.OrderHistoryInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicGetUserOrderHistories
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/users/{userId}/orders/{orderNo}/history";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String orderNo;
    private String userId;

    @Deprecated
    public PublicGetUserOrderHistories(String namespace, String orderNo, String userId) {
        this.namespace = namespace;
        this.orderNo = orderNo;
        this.userId = userId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.orderNo != null) {
            pathParams.put("orderNo", this.orderNo);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.orderNo == null) {
            return false;
        }
        return this.userId != null;
    }

    public List<OrderHistoryInfo> parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<OrderHistoryInfo>>(){});
    }

    public static PublicGetUserOrderHistoriesBuilder builder() {
        return new PublicGetUserOrderHistoriesBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public static class PublicGetUserOrderHistoriesBuilder {
        private String namespace;
        private String orderNo;
        private String userId;

        PublicGetUserOrderHistoriesBuilder() {
        }

        public PublicGetUserOrderHistoriesBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicGetUserOrderHistoriesBuilder orderNo(String orderNo) {
            this.orderNo = orderNo;
            return this;
        }

        public PublicGetUserOrderHistoriesBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public PublicGetUserOrderHistories build() {
            return new PublicGetUserOrderHistories(this.namespace, this.orderNo, this.userId);
        }

        public String toString() {
            return "PublicGetUserOrderHistories.PublicGetUserOrderHistoriesBuilder(namespace=" + this.namespace + ", orderNo=" + this.orderNo + ", userId=" + this.userId + ")";
        }
    }
}

