/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.key_group;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.KeyGroupInfo;
import net.accelbyte.sdk.api.platform.models.KeyGroupUpdate;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class UpdateKeyGroup
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/keygroups/{keyGroupId}";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String keyGroupId;
    private String namespace;
    private KeyGroupUpdate body;

    @Deprecated
    public UpdateKeyGroup(String keyGroupId, String namespace, KeyGroupUpdate body) {
        this.keyGroupId = keyGroupId;
        this.namespace = namespace;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.keyGroupId != null) {
            pathParams.put("keyGroupId", this.keyGroupId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public KeyGroupUpdate getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.keyGroupId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public KeyGroupInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new KeyGroupInfo().createFromJson(json);
    }

    public static UpdateKeyGroupBuilder builder() {
        return new UpdateKeyGroupBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getKeyGroupId() {
        return this.keyGroupId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public KeyGroupUpdate getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setKeyGroupId(String keyGroupId) {
        this.keyGroupId = keyGroupId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBody(KeyGroupUpdate body) {
        this.body = body;
    }

    public static class UpdateKeyGroupBuilder {
        private String keyGroupId;
        private String namespace;
        private KeyGroupUpdate body;

        UpdateKeyGroupBuilder() {
        }

        public UpdateKeyGroupBuilder keyGroupId(String keyGroupId) {
            this.keyGroupId = keyGroupId;
            return this;
        }

        public UpdateKeyGroupBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public UpdateKeyGroupBuilder body(KeyGroupUpdate body) {
            this.body = body;
            return this;
        }

        public UpdateKeyGroup build() {
            return new UpdateKeyGroup(this.keyGroupId, this.namespace, this.body);
        }

        public String toString() {
            return "UpdateKeyGroup.UpdateKeyGroupBuilder(keyGroupId=" + this.keyGroupId + ", namespace=" + this.namespace + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

