/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.item;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.FullItemInfo;
import net.accelbyte.sdk.api.platform.models.ItemUpdate;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class UpdateItem
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/items/{itemId}";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String itemId;
    private String namespace;
    private String storeId;
    private ItemUpdate body;

    @Deprecated
    public UpdateItem(String itemId, String namespace, String storeId, ItemUpdate body) {
        this.itemId = itemId;
        this.namespace = namespace;
        this.storeId = storeId;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.itemId != null) {
            pathParams.put("itemId", this.itemId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("storeId", this.storeId == null ? null : Arrays.asList(this.storeId));
        return queryParams;
    }

    public ItemUpdate getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.itemId == null) {
            return false;
        }
        if (this.namespace == null) {
            return false;
        }
        return this.storeId != null;
    }

    public FullItemInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new FullItemInfo().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("storeId", "None");
        return result;
    }

    public static UpdateItemBuilder builder() {
        return new UpdateItemBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public ItemUpdate getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public void setBody(ItemUpdate body) {
        this.body = body;
    }

    public static class UpdateItemBuilder {
        private String itemId;
        private String namespace;
        private String storeId;
        private ItemUpdate body;

        UpdateItemBuilder() {
        }

        public UpdateItemBuilder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public UpdateItemBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public UpdateItemBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public UpdateItemBuilder body(ItemUpdate body) {
            this.body = body;
            return this;
        }

        public UpdateItem build() {
            return new UpdateItem(this.itemId, this.namespace, this.storeId, this.body);
        }

        public String toString() {
            return "UpdateItem.UpdateItemBuilder(itemId=" + this.itemId + ", namespace=" + this.namespace + ", storeId=" + this.storeId + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

