/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.item;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.FullItemPagingSlicedResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class SearchItems
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/items/search";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private Boolean activeOnly;
    private String itemType;
    private Integer limit;
    private Integer offset;
    private String sortBy;
    private String storeId;
    private String keyword;
    private String language;

    @Deprecated
    public SearchItems(String namespace, Boolean activeOnly, String itemType, Integer limit, Integer offset, String sortBy, String storeId, String keyword, String language) {
        this.namespace = namespace;
        this.activeOnly = activeOnly;
        this.itemType = itemType;
        this.limit = limit;
        this.offset = offset;
        this.sortBy = sortBy;
        this.storeId = storeId;
        this.keyword = keyword;
        this.language = language;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("activeOnly", this.activeOnly == null ? null : Arrays.asList(String.valueOf(this.activeOnly)));
        queryParams.put("itemType", this.itemType == null ? null : Arrays.asList(this.itemType));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("sortBy", this.sortBy == null ? null : Arrays.asList(this.sortBy));
        queryParams.put("storeId", this.storeId == null ? null : Arrays.asList(this.storeId));
        queryParams.put("keyword", this.keyword == null ? null : Arrays.asList(this.keyword));
        queryParams.put("language", this.language == null ? null : Arrays.asList(this.language));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.keyword == null) {
            return false;
        }
        return this.language != null;
    }

    public FullItemPagingSlicedResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new FullItemPagingSlicedResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("activeOnly", "None");
        result.put("itemType", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("sortBy", "None");
        result.put("storeId", "None");
        result.put("keyword", "None");
        result.put("language", "None");
        return result;
    }

    public static SearchItemsBuilder builder() {
        return new SearchItemsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Boolean getActiveOnly() {
        return this.activeOnly;
    }

    public String getItemType() {
        return this.itemType;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setActiveOnly(Boolean activeOnly) {
        this.activeOnly = activeOnly;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public static class SearchItemsBuilder {
        private String namespace;
        private Boolean activeOnly;
        private Integer limit;
        private Integer offset;
        private String sortBy;
        private String storeId;
        private String keyword;
        private String language;
        private String itemType;

        public SearchItemsBuilder itemType(String itemType) {
            this.itemType = itemType;
            return this;
        }

        public SearchItemsBuilder itemTypeFromEnum(ItemType itemType) {
            this.itemType = itemType.toString();
            return this;
        }

        SearchItemsBuilder() {
        }

        public SearchItemsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public SearchItemsBuilder activeOnly(Boolean activeOnly) {
            this.activeOnly = activeOnly;
            return this;
        }

        public SearchItemsBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public SearchItemsBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public SearchItemsBuilder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public SearchItemsBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public SearchItemsBuilder keyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public SearchItemsBuilder language(String language) {
            this.language = language;
            return this;
        }

        public SearchItems build() {
            return new SearchItems(this.namespace, this.activeOnly, this.itemType, this.limit, this.offset, this.sortBy, this.storeId, this.keyword, this.language);
        }

        public String toString() {
            return "SearchItems.SearchItemsBuilder(namespace=" + this.namespace + ", activeOnly=" + this.activeOnly + ", itemType=" + this.itemType + ", limit=" + this.limit + ", offset=" + this.offset + ", sortBy=" + this.sortBy + ", storeId=" + this.storeId + ", keyword=" + this.keyword + ", language=" + this.language + ")";
        }
    }

    public static enum ItemType {
        APP("APP"),
        BUNDLE("BUNDLE"),
        CODE("CODE"),
        COINS("COINS"),
        EXTENSION("EXTENSION"),
        INGAMEITEM("INGAMEITEM"),
        LOOTBOX("LOOTBOX"),
        MEDIA("MEDIA"),
        OPTIONBOX("OPTIONBOX"),
        SEASON("SEASON"),
        SUBSCRIPTION("SUBSCRIPTION");

        private String value;

        private ItemType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

