/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.item;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.FullItemPagingSlicedResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class QueryItems1
extends Operation {
    private String path = "/platform/v2/admin/namespaces/{namespace}/items/byCriteria";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String appType;
    private String availableDate;
    private String baseAppId;
    private String categoryPath;
    private String features;
    private Boolean includeSubCategoryItem;
    private String itemName;
    private String itemStatus;
    private String itemType;
    private Integer limit;
    private Integer offset;
    private String region;
    private Boolean sectionExclusive;
    private List<String> sortBy;
    private String storeId;
    private String tags;
    private String targetNamespace;

    @Deprecated
    public QueryItems1(String namespace, String appType, String availableDate, String baseAppId, String categoryPath, String features, Boolean includeSubCategoryItem, String itemName, String itemStatus, String itemType, Integer limit, Integer offset, String region, Boolean sectionExclusive, List<String> sortBy, String storeId, String tags, String targetNamespace) {
        this.namespace = namespace;
        this.appType = appType;
        this.availableDate = availableDate;
        this.baseAppId = baseAppId;
        this.categoryPath = categoryPath;
        this.features = features;
        this.includeSubCategoryItem = includeSubCategoryItem;
        this.itemName = itemName;
        this.itemStatus = itemStatus;
        this.itemType = itemType;
        this.limit = limit;
        this.offset = offset;
        this.region = region;
        this.sectionExclusive = sectionExclusive;
        this.sortBy = sortBy;
        this.storeId = storeId;
        this.tags = tags;
        this.targetNamespace = targetNamespace;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("appType", this.appType == null ? null : Arrays.asList(this.appType));
        queryParams.put("availableDate", this.availableDate == null ? null : Arrays.asList(this.availableDate));
        queryParams.put("baseAppId", this.baseAppId == null ? null : Arrays.asList(this.baseAppId));
        queryParams.put("categoryPath", this.categoryPath == null ? null : Arrays.asList(this.categoryPath));
        queryParams.put("features", this.features == null ? null : Arrays.asList(this.features));
        queryParams.put("includeSubCategoryItem", this.includeSubCategoryItem == null ? null : Arrays.asList(String.valueOf(this.includeSubCategoryItem)));
        queryParams.put("itemName", this.itemName == null ? null : Arrays.asList(this.itemName));
        queryParams.put("itemStatus", this.itemStatus == null ? null : Arrays.asList(this.itemStatus));
        queryParams.put("itemType", this.itemType == null ? null : Arrays.asList(this.itemType));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("region", this.region == null ? null : Arrays.asList(this.region));
        queryParams.put("sectionExclusive", this.sectionExclusive == null ? null : Arrays.asList(String.valueOf(this.sectionExclusive)));
        queryParams.put("sortBy", this.sortBy == null ? null : this.sortBy);
        queryParams.put("storeId", this.storeId == null ? null : Arrays.asList(this.storeId));
        queryParams.put("tags", this.tags == null ? null : Arrays.asList(this.tags));
        queryParams.put("targetNamespace", this.targetNamespace == null ? null : Arrays.asList(this.targetNamespace));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public FullItemPagingSlicedResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new FullItemPagingSlicedResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("appType", "None");
        result.put("availableDate", "None");
        result.put("baseAppId", "None");
        result.put("categoryPath", "None");
        result.put("features", "None");
        result.put("includeSubCategoryItem", "None");
        result.put("itemName", "None");
        result.put("itemStatus", "None");
        result.put("itemType", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("region", "None");
        result.put("sectionExclusive", "None");
        result.put("sortBy", "csv");
        result.put("storeId", "None");
        result.put("tags", "None");
        result.put("targetNamespace", "None");
        return result;
    }

    public static QueryItems1Builder builder() {
        return new QueryItems1Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getAppType() {
        return this.appType;
    }

    public String getAvailableDate() {
        return this.availableDate;
    }

    public String getBaseAppId() {
        return this.baseAppId;
    }

    public String getCategoryPath() {
        return this.categoryPath;
    }

    public String getFeatures() {
        return this.features;
    }

    public Boolean getIncludeSubCategoryItem() {
        return this.includeSubCategoryItem;
    }

    public String getItemName() {
        return this.itemName;
    }

    public String getItemStatus() {
        return this.itemStatus;
    }

    public String getItemType() {
        return this.itemType;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getRegion() {
        return this.region;
    }

    public Boolean getSectionExclusive() {
        return this.sectionExclusive;
    }

    public List<String> getSortBy() {
        return this.sortBy;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public String getTags() {
        return this.tags;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setAppType(String appType) {
        this.appType = appType;
    }

    public void setAvailableDate(String availableDate) {
        this.availableDate = availableDate;
    }

    public void setBaseAppId(String baseAppId) {
        this.baseAppId = baseAppId;
    }

    public void setCategoryPath(String categoryPath) {
        this.categoryPath = categoryPath;
    }

    public void setFeatures(String features) {
        this.features = features;
    }

    public void setIncludeSubCategoryItem(Boolean includeSubCategoryItem) {
        this.includeSubCategoryItem = includeSubCategoryItem;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public void setItemStatus(String itemStatus) {
        this.itemStatus = itemStatus;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setSectionExclusive(Boolean sectionExclusive) {
        this.sectionExclusive = sectionExclusive;
    }

    public void setSortBy(List<String> sortBy) {
        this.sortBy = sortBy;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public static class QueryItems1Builder {
        private String namespace;
        private String availableDate;
        private String baseAppId;
        private String categoryPath;
        private String features;
        private Boolean includeSubCategoryItem;
        private String itemName;
        private Integer limit;
        private Integer offset;
        private String region;
        private Boolean sectionExclusive;
        private String storeId;
        private String tags;
        private String targetNamespace;
        private String appType;
        private String itemStatus;
        private String itemType;
        private List<String> sortBy;

        public QueryItems1Builder appType(String appType) {
            this.appType = appType;
            return this;
        }

        public QueryItems1Builder appTypeFromEnum(AppType appType) {
            this.appType = appType.toString();
            return this;
        }

        public QueryItems1Builder itemStatus(String itemStatus) {
            this.itemStatus = itemStatus;
            return this;
        }

        public QueryItems1Builder itemStatusFromEnum(ItemStatus itemStatus) {
            this.itemStatus = itemStatus.toString();
            return this;
        }

        public QueryItems1Builder itemType(String itemType) {
            this.itemType = itemType;
            return this;
        }

        public QueryItems1Builder itemTypeFromEnum(ItemType itemType) {
            this.itemType = itemType.toString();
            return this;
        }

        public QueryItems1Builder sortBy(List<String> sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public QueryItems1Builder sortByFromEnum(List<SortBy> sortBy) {
            ArrayList<String> en = new ArrayList<String>();
            for (SortBy e : sortBy) {
                en.add(e.toString());
            }
            this.sortBy = en;
            return this;
        }

        QueryItems1Builder() {
        }

        public QueryItems1Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public QueryItems1Builder availableDate(String availableDate) {
            this.availableDate = availableDate;
            return this;
        }

        public QueryItems1Builder baseAppId(String baseAppId) {
            this.baseAppId = baseAppId;
            return this;
        }

        public QueryItems1Builder categoryPath(String categoryPath) {
            this.categoryPath = categoryPath;
            return this;
        }

        public QueryItems1Builder features(String features) {
            this.features = features;
            return this;
        }

        public QueryItems1Builder includeSubCategoryItem(Boolean includeSubCategoryItem) {
            this.includeSubCategoryItem = includeSubCategoryItem;
            return this;
        }

        public QueryItems1Builder itemName(String itemName) {
            this.itemName = itemName;
            return this;
        }

        public QueryItems1Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public QueryItems1Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public QueryItems1Builder region(String region) {
            this.region = region;
            return this;
        }

        public QueryItems1Builder sectionExclusive(Boolean sectionExclusive) {
            this.sectionExclusive = sectionExclusive;
            return this;
        }

        public QueryItems1Builder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public QueryItems1Builder tags(String tags) {
            this.tags = tags;
            return this;
        }

        public QueryItems1Builder targetNamespace(String targetNamespace) {
            this.targetNamespace = targetNamespace;
            return this;
        }

        public QueryItems1 build() {
            return new QueryItems1(this.namespace, this.appType, this.availableDate, this.baseAppId, this.categoryPath, this.features, this.includeSubCategoryItem, this.itemName, this.itemStatus, this.itemType, this.limit, this.offset, this.region, this.sectionExclusive, this.sortBy, this.storeId, this.tags, this.targetNamespace);
        }

        public String toString() {
            return "QueryItems1.QueryItems1Builder(namespace=" + this.namespace + ", appType=" + this.appType + ", availableDate=" + this.availableDate + ", baseAppId=" + this.baseAppId + ", categoryPath=" + this.categoryPath + ", features=" + this.features + ", includeSubCategoryItem=" + this.includeSubCategoryItem + ", itemName=" + this.itemName + ", itemStatus=" + this.itemStatus + ", itemType=" + this.itemType + ", limit=" + this.limit + ", offset=" + this.offset + ", region=" + this.region + ", sectionExclusive=" + this.sectionExclusive + ", sortBy=" + this.sortBy + ", storeId=" + this.storeId + ", tags=" + this.tags + ", targetNamespace=" + this.targetNamespace + ")";
        }
    }

    public static enum SortBy {
        Name("name"),
        Nameasc("name:asc"),
        Namedesc("name:desc"),
        CreatedAt("createdAt"),
        CreatedAtasc("createdAt:asc"),
        CreatedAtdesc("createdAt:desc"),
        UpdatedAt("updatedAt"),
        UpdatedAtasc("updatedAt:asc"),
        UpdatedAtdesc("updatedAt:desc"),
        DisplayOrder("displayOrder"),
        DisplayOrderasc("displayOrder:asc"),
        DisplayOrderdesc("displayOrder:desc");

        private String value;

        private SortBy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum ItemType {
        APP("APP"),
        BUNDLE("BUNDLE"),
        CODE("CODE"),
        COINS("COINS"),
        EXTENSION("EXTENSION"),
        INGAMEITEM("INGAMEITEM"),
        LOOTBOX("LOOTBOX"),
        MEDIA("MEDIA"),
        OPTIONBOX("OPTIONBOX"),
        SEASON("SEASON"),
        SUBSCRIPTION("SUBSCRIPTION");

        private String value;

        private ItemType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum ItemStatus {
        ACTIVE("ACTIVE"),
        INACTIVE("INACTIVE");

        private String value;

        private ItemStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum AppType {
        DEMO("DEMO"),
        DLC("DLC"),
        GAME("GAME"),
        SOFTWARE("SOFTWARE");

        private String value;

        private AppType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

