/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.item;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.ItemPagingSlicedResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicQueryItems
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/items/byCriteria";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String appType;
    private String baseAppId;
    private String categoryPath;
    private String features;
    private Boolean includeSubCategoryItem;
    private String itemType;
    private String language;
    private Integer limit;
    private Integer offset;
    private String region;
    private List<String> sortBy;
    private String storeId;
    private String tags;

    @Deprecated
    public PublicQueryItems(String namespace, String appType, String baseAppId, String categoryPath, String features, Boolean includeSubCategoryItem, String itemType, String language, Integer limit, Integer offset, String region, List<String> sortBy, String storeId, String tags) {
        this.namespace = namespace;
        this.appType = appType;
        this.baseAppId = baseAppId;
        this.categoryPath = categoryPath;
        this.features = features;
        this.includeSubCategoryItem = includeSubCategoryItem;
        this.itemType = itemType;
        this.language = language;
        this.limit = limit;
        this.offset = offset;
        this.region = region;
        this.sortBy = sortBy;
        this.storeId = storeId;
        this.tags = tags;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("appType", this.appType == null ? null : Arrays.asList(this.appType));
        queryParams.put("baseAppId", this.baseAppId == null ? null : Arrays.asList(this.baseAppId));
        queryParams.put("categoryPath", this.categoryPath == null ? null : Arrays.asList(this.categoryPath));
        queryParams.put("features", this.features == null ? null : Arrays.asList(this.features));
        queryParams.put("includeSubCategoryItem", this.includeSubCategoryItem == null ? null : Arrays.asList(String.valueOf(this.includeSubCategoryItem)));
        queryParams.put("itemType", this.itemType == null ? null : Arrays.asList(this.itemType));
        queryParams.put("language", this.language == null ? null : Arrays.asList(this.language));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("region", this.region == null ? null : Arrays.asList(this.region));
        queryParams.put("sortBy", this.sortBy == null ? null : this.sortBy);
        queryParams.put("storeId", this.storeId == null ? null : Arrays.asList(this.storeId));
        queryParams.put("tags", this.tags == null ? null : Arrays.asList(this.tags));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public ItemPagingSlicedResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ItemPagingSlicedResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("appType", "None");
        result.put("baseAppId", "None");
        result.put("categoryPath", "None");
        result.put("features", "None");
        result.put("includeSubCategoryItem", "None");
        result.put("itemType", "None");
        result.put("language", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("region", "None");
        result.put("sortBy", "csv");
        result.put("storeId", "None");
        result.put("tags", "None");
        return result;
    }

    public static PublicQueryItemsBuilder builder() {
        return new PublicQueryItemsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getAppType() {
        return this.appType;
    }

    public String getBaseAppId() {
        return this.baseAppId;
    }

    public String getCategoryPath() {
        return this.categoryPath;
    }

    public String getFeatures() {
        return this.features;
    }

    public Boolean getIncludeSubCategoryItem() {
        return this.includeSubCategoryItem;
    }

    public String getItemType() {
        return this.itemType;
    }

    public String getLanguage() {
        return this.language;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getRegion() {
        return this.region;
    }

    public List<String> getSortBy() {
        return this.sortBy;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public String getTags() {
        return this.tags;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setAppType(String appType) {
        this.appType = appType;
    }

    public void setBaseAppId(String baseAppId) {
        this.baseAppId = baseAppId;
    }

    public void setCategoryPath(String categoryPath) {
        this.categoryPath = categoryPath;
    }

    public void setFeatures(String features) {
        this.features = features;
    }

    public void setIncludeSubCategoryItem(Boolean includeSubCategoryItem) {
        this.includeSubCategoryItem = includeSubCategoryItem;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setSortBy(List<String> sortBy) {
        this.sortBy = sortBy;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public static class PublicQueryItemsBuilder {
        private String namespace;
        private String baseAppId;
        private String categoryPath;
        private String features;
        private Boolean includeSubCategoryItem;
        private String language;
        private Integer limit;
        private Integer offset;
        private String region;
        private String storeId;
        private String tags;
        private String appType;
        private String itemType;
        private List<String> sortBy;

        public PublicQueryItemsBuilder appType(String appType) {
            this.appType = appType;
            return this;
        }

        public PublicQueryItemsBuilder appTypeFromEnum(AppType appType) {
            this.appType = appType.toString();
            return this;
        }

        public PublicQueryItemsBuilder itemType(String itemType) {
            this.itemType = itemType;
            return this;
        }

        public PublicQueryItemsBuilder itemTypeFromEnum(ItemType itemType) {
            this.itemType = itemType.toString();
            return this;
        }

        public PublicQueryItemsBuilder sortBy(List<String> sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public PublicQueryItemsBuilder sortByFromEnum(List<SortBy> sortBy) {
            ArrayList<String> en = new ArrayList<String>();
            for (SortBy e : sortBy) {
                en.add(e.toString());
            }
            this.sortBy = en;
            return this;
        }

        PublicQueryItemsBuilder() {
        }

        public PublicQueryItemsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicQueryItemsBuilder baseAppId(String baseAppId) {
            this.baseAppId = baseAppId;
            return this;
        }

        public PublicQueryItemsBuilder categoryPath(String categoryPath) {
            this.categoryPath = categoryPath;
            return this;
        }

        public PublicQueryItemsBuilder features(String features) {
            this.features = features;
            return this;
        }

        public PublicQueryItemsBuilder includeSubCategoryItem(Boolean includeSubCategoryItem) {
            this.includeSubCategoryItem = includeSubCategoryItem;
            return this;
        }

        public PublicQueryItemsBuilder language(String language) {
            this.language = language;
            return this;
        }

        public PublicQueryItemsBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public PublicQueryItemsBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public PublicQueryItemsBuilder region(String region) {
            this.region = region;
            return this;
        }

        public PublicQueryItemsBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public PublicQueryItemsBuilder tags(String tags) {
            this.tags = tags;
            return this;
        }

        public PublicQueryItems build() {
            return new PublicQueryItems(this.namespace, this.appType, this.baseAppId, this.categoryPath, this.features, this.includeSubCategoryItem, this.itemType, this.language, this.limit, this.offset, this.region, this.sortBy, this.storeId, this.tags);
        }

        public String toString() {
            return "PublicQueryItems.PublicQueryItemsBuilder(namespace=" + this.namespace + ", appType=" + this.appType + ", baseAppId=" + this.baseAppId + ", categoryPath=" + this.categoryPath + ", features=" + this.features + ", includeSubCategoryItem=" + this.includeSubCategoryItem + ", itemType=" + this.itemType + ", language=" + this.language + ", limit=" + this.limit + ", offset=" + this.offset + ", region=" + this.region + ", sortBy=" + this.sortBy + ", storeId=" + this.storeId + ", tags=" + this.tags + ")";
        }
    }

    public static enum SortBy {
        Name("name"),
        Nameasc("name:asc"),
        Namedesc("name:desc"),
        CreatedAt("createdAt"),
        CreatedAtasc("createdAt:asc"),
        CreatedAtdesc("createdAt:desc"),
        UpdatedAt("updatedAt"),
        UpdatedAtasc("updatedAt:asc"),
        UpdatedAtdesc("updatedAt:desc"),
        DisplayOrder("displayOrder"),
        DisplayOrderasc("displayOrder:asc"),
        DisplayOrderdesc("displayOrder:desc");

        private String value;

        private SortBy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum ItemType {
        APP("APP"),
        BUNDLE("BUNDLE"),
        CODE("CODE"),
        COINS("COINS"),
        EXTENSION("EXTENSION"),
        INGAMEITEM("INGAMEITEM"),
        LOOTBOX("LOOTBOX"),
        MEDIA("MEDIA"),
        OPTIONBOX("OPTIONBOX"),
        SEASON("SEASON"),
        SUBSCRIPTION("SUBSCRIPTION");

        private String value;

        private ItemType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum AppType {
        DEMO("DEMO"),
        DLC("DLC"),
        GAME("GAME"),
        SOFTWARE("SOFTWARE");

        private String value;

        private AppType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

