/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.item;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.EstimatedPriceInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicGetEstimatedPrice
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/items/estimatedPrice";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String region;
    private String storeId;
    private String itemIds;

    @Deprecated
    public PublicGetEstimatedPrice(String namespace, String region, String storeId, String itemIds) {
        this.namespace = namespace;
        this.region = region;
        this.storeId = storeId;
        this.itemIds = itemIds;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("region", this.region == null ? null : Arrays.asList(this.region));
        queryParams.put("storeId", this.storeId == null ? null : Arrays.asList(this.storeId));
        queryParams.put("itemIds", this.itemIds == null ? null : Arrays.asList(this.itemIds));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.itemIds != null;
    }

    public List<EstimatedPriceInfo> parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<EstimatedPriceInfo>>(){});
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("region", "None");
        result.put("storeId", "None");
        result.put("itemIds", "None");
        return result;
    }

    public static PublicGetEstimatedPriceBuilder builder() {
        return new PublicGetEstimatedPriceBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getRegion() {
        return this.region;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public String getItemIds() {
        return this.itemIds;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public void setItemIds(String itemIds) {
        this.itemIds = itemIds;
    }

    public static class PublicGetEstimatedPriceBuilder {
        private String namespace;
        private String region;
        private String storeId;
        private String itemIds;

        PublicGetEstimatedPriceBuilder() {
        }

        public PublicGetEstimatedPriceBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicGetEstimatedPriceBuilder region(String region) {
            this.region = region;
            return this;
        }

        public PublicGetEstimatedPriceBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public PublicGetEstimatedPriceBuilder itemIds(String itemIds) {
            this.itemIds = itemIds;
            return this;
        }

        public PublicGetEstimatedPrice build() {
            return new PublicGetEstimatedPrice(this.namespace, this.region, this.storeId, this.itemIds);
        }

        public String toString() {
            return "PublicGetEstimatedPrice.PublicGetEstimatedPriceBuilder(namespace=" + this.namespace + ", region=" + this.region + ", storeId=" + this.storeId + ", itemIds=" + this.itemIds + ")";
        }
    }
}

