/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.item;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.AppInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicGetApp
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/items/{itemId}/app/locale";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String itemId;
    private String namespace;
    private String language;
    private String region;
    private String storeId;

    @Deprecated
    public PublicGetApp(String itemId, String namespace, String language, String region, String storeId) {
        this.itemId = itemId;
        this.namespace = namespace;
        this.language = language;
        this.region = region;
        this.storeId = storeId;
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.itemId != null) {
            pathParams.put("itemId", this.itemId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("language", this.language == null ? null : Arrays.asList(this.language));
        queryParams.put("region", this.region == null ? null : Arrays.asList(this.region));
        queryParams.put("storeId", this.storeId == null ? null : Arrays.asList(this.storeId));
        return queryParams;
    }

    public boolean isValid() {
        if (this.itemId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public AppInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new AppInfo().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("language", "None");
        result.put("region", "None");
        result.put("storeId", "None");
        return result;
    }

    public static PublicGetAppBuilder builder() {
        return new PublicGetAppBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getRegion() {
        return this.region;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public static class PublicGetAppBuilder {
        private String itemId;
        private String namespace;
        private String language;
        private String region;
        private String storeId;

        PublicGetAppBuilder() {
        }

        public PublicGetAppBuilder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public PublicGetAppBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicGetAppBuilder language(String language) {
            this.language = language;
            return this;
        }

        public PublicGetAppBuilder region(String region) {
            this.region = region;
            return this;
        }

        public PublicGetAppBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public PublicGetApp build() {
            return new PublicGetApp(this.itemId, this.namespace, this.language, this.region, this.storeId);
        }

        public String toString() {
            return "PublicGetApp.PublicGetAppBuilder(itemId=" + this.itemId + ", namespace=" + this.namespace + ", language=" + this.language + ", region=" + this.region + ", storeId=" + this.storeId + ")";
        }
    }
}

