/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.item;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.FullItemInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class DefeatureItem
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/items/{itemId}/features/{feature}";
    private String method = "DELETE";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String feature;
    private String itemId;
    private String namespace;
    private String storeId;

    @Deprecated
    public DefeatureItem(String feature, String itemId, String namespace, String storeId) {
        this.feature = feature;
        this.itemId = itemId;
        this.namespace = namespace;
        this.storeId = storeId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.feature != null) {
            pathParams.put("feature", this.feature);
        }
        if (this.itemId != null) {
            pathParams.put("itemId", this.itemId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("storeId", this.storeId == null ? null : Arrays.asList(this.storeId));
        return queryParams;
    }

    public boolean isValid() {
        if (this.feature == null) {
            return false;
        }
        if (this.itemId == null) {
            return false;
        }
        if (this.namespace == null) {
            return false;
        }
        return this.storeId != null;
    }

    public FullItemInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new FullItemInfo().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("storeId", "None");
        return result;
    }

    public static DefeatureItemBuilder builder() {
        return new DefeatureItemBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getFeature() {
        return this.feature;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setFeature(String feature) {
        this.feature = feature;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public static class DefeatureItemBuilder {
        private String feature;
        private String itemId;
        private String namespace;
        private String storeId;

        DefeatureItemBuilder() {
        }

        public DefeatureItemBuilder feature(String feature) {
            this.feature = feature;
            return this;
        }

        public DefeatureItemBuilder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public DefeatureItemBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public DefeatureItemBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public DefeatureItem build() {
            return new DefeatureItem(this.feature, this.itemId, this.namespace, this.storeId);
        }

        public String toString() {
            return "DefeatureItem.DefeatureItemBuilder(feature=" + this.feature + ", itemId=" + this.itemId + ", namespace=" + this.namespace + ", storeId=" + this.storeId + ")";
        }
    }
}

