/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.item;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.ItemAcquireRequest;
import net.accelbyte.sdk.api.platform.models.ItemAcquireResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AcquireItem
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/items/{itemId}/acquire";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String itemId;
    private String namespace;
    private ItemAcquireRequest body;

    @Deprecated
    public AcquireItem(String itemId, String namespace, ItemAcquireRequest body) {
        this.itemId = itemId;
        this.namespace = namespace;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.itemId != null) {
            pathParams.put("itemId", this.itemId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public ItemAcquireRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.itemId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public ItemAcquireResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ItemAcquireResult().createFromJson(json);
    }

    public static AcquireItemBuilder builder() {
        return new AcquireItemBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ItemAcquireRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBody(ItemAcquireRequest body) {
        this.body = body;
    }

    public static class AcquireItemBuilder {
        private String itemId;
        private String namespace;
        private ItemAcquireRequest body;

        AcquireItemBuilder() {
        }

        public AcquireItemBuilder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public AcquireItemBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AcquireItemBuilder body(ItemAcquireRequest body) {
            this.body = body;
            return this;
        }

        public AcquireItem build() {
            return new AcquireItem(this.itemId, this.namespace, this.body);
        }

        public String toString() {
            return "AcquireItem.AcquireItemBuilder(itemId=" + this.itemId + ", namespace=" + this.namespace + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

