/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.invoice;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.InvoiceSummary;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class GenerateInvoiceSummary
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/invoice/summary";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String feature;
    private String itemId;
    private String itemType;
    private String endTime;
    private String startTime;

    @Deprecated
    public GenerateInvoiceSummary(String namespace, String feature, String itemId, String itemType, String endTime, String startTime) {
        this.namespace = namespace;
        this.feature = feature;
        this.itemId = itemId;
        this.itemType = itemType;
        this.endTime = endTime;
        this.startTime = startTime;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("feature", this.feature == null ? null : Arrays.asList(this.feature));
        queryParams.put("itemId", this.itemId == null ? null : Arrays.asList(this.itemId));
        queryParams.put("itemType", this.itemType == null ? null : Arrays.asList(this.itemType));
        queryParams.put("endTime", this.endTime == null ? null : Arrays.asList(this.endTime));
        queryParams.put("startTime", this.startTime == null ? null : Arrays.asList(this.startTime));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.endTime == null) {
            return false;
        }
        return this.startTime != null;
    }

    public InvoiceSummary parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new InvoiceSummary().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("feature", "None");
        result.put("itemId", "None");
        result.put("itemType", "None");
        result.put("endTime", "None");
        result.put("startTime", "None");
        return result;
    }

    public static GenerateInvoiceSummaryBuilder builder() {
        return new GenerateInvoiceSummaryBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getFeature() {
        return this.feature;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getItemType() {
        return this.itemType;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setFeature(String feature) {
        this.feature = feature;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public static class GenerateInvoiceSummaryBuilder {
        private String namespace;
        private String feature;
        private String itemId;
        private String endTime;
        private String startTime;
        private String itemType;

        public GenerateInvoiceSummaryBuilder itemType(String itemType) {
            this.itemType = itemType;
            return this;
        }

        public GenerateInvoiceSummaryBuilder itemTypeFromEnum(ItemType itemType) {
            this.itemType = itemType.toString();
            return this;
        }

        GenerateInvoiceSummaryBuilder() {
        }

        public GenerateInvoiceSummaryBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GenerateInvoiceSummaryBuilder feature(String feature) {
            this.feature = feature;
            return this;
        }

        public GenerateInvoiceSummaryBuilder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public GenerateInvoiceSummaryBuilder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public GenerateInvoiceSummaryBuilder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public GenerateInvoiceSummary build() {
            return new GenerateInvoiceSummary(this.namespace, this.feature, this.itemId, this.itemType, this.endTime, this.startTime);
        }

        public String toString() {
            return "GenerateInvoiceSummary.GenerateInvoiceSummaryBuilder(namespace=" + this.namespace + ", feature=" + this.feature + ", itemId=" + this.itemId + ", itemType=" + this.itemType + ", endTime=" + this.endTime + ", startTime=" + this.startTime + ")";
        }
    }

    public static enum ItemType {
        APP("APP"),
        BUNDLE("BUNDLE"),
        CODE("CODE"),
        COINS("COINS"),
        EXTENSION("EXTENSION"),
        INGAMEITEM("INGAMEITEM"),
        LOOTBOX("LOOTBOX"),
        MEDIA("MEDIA"),
        OPTIONBOX("OPTIONBOX"),
        SEASON("SEASON"),
        SUBSCRIPTION("SUBSCRIPTION");

        private String value;

        private ItemType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

