/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.iap;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.XblIAPConfigInfo;
import net.accelbyte.sdk.api.platform.models.XblIAPConfigRequest;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class UpdateXblIAPConfig
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/iap/config/xbl";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private XblIAPConfigRequest body;

    @Deprecated
    public UpdateXblIAPConfig(String namespace, XblIAPConfigRequest body) {
        this.namespace = namespace;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public XblIAPConfigRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public XblIAPConfigInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new XblIAPConfigInfo().createFromJson(json);
    }

    public static UpdateXblIAPConfigBuilder builder() {
        return new UpdateXblIAPConfigBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public XblIAPConfigRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBody(XblIAPConfigRequest body) {
        this.body = body;
    }

    public static class UpdateXblIAPConfigBuilder {
        private String namespace;
        private XblIAPConfigRequest body;

        UpdateXblIAPConfigBuilder() {
        }

        public UpdateXblIAPConfigBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public UpdateXblIAPConfigBuilder body(XblIAPConfigRequest body) {
            this.body = body;
            return this;
        }

        public UpdateXblIAPConfig build() {
            return new UpdateXblIAPConfig(this.namespace, this.body);
        }

        public String toString() {
            return "UpdateXblIAPConfig.UpdateXblIAPConfigBuilder(namespace=" + this.namespace + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

