/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.iap;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.GoogleIAPConfigInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class UpdateGoogleP12File
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/iap/config/google/cert";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("multipart/form-data");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private File file;

    @Deprecated
    public UpdateGoogleP12File(String namespace, File file) {
        this.namespace = namespace;
        this.file = file;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, Object> getFormParams() {
        HashMap<String, Object> formDataParams = new HashMap<String, Object>();
        if (this.file != null) {
            formDataParams.put("file", this.file);
        }
        return formDataParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public GoogleIAPConfigInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new GoogleIAPConfigInfo().createFromJson(json);
    }

    public static UpdateGoogleP12FileBuilder builder() {
        return new UpdateGoogleP12FileBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public File getFile() {
        return this.file;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public static class UpdateGoogleP12FileBuilder {
        private String namespace;
        private File file;

        UpdateGoogleP12FileBuilder() {
        }

        public UpdateGoogleP12FileBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public UpdateGoogleP12FileBuilder file(File file) {
            this.file = file;
            return this;
        }

        public UpdateGoogleP12File build() {
            return new UpdateGoogleP12File(this.namespace, this.file);
        }

        public String toString() {
            return "UpdateGoogleP12File.UpdateGoogleP12FileBuilder(namespace=" + this.namespace + ", file=" + this.file + ")";
        }
    }
}

