/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.iap;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.XblReconcileRequest;
import net.accelbyte.sdk.api.platform.models.XblReconcileResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class SyncXboxInventory
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/users/{userId}/iap/xbl/sync";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private XblReconcileRequest body;

    @Deprecated
    public SyncXboxInventory(String namespace, String userId, XblReconcileRequest body) {
        this.namespace = namespace;
        this.userId = userId;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public XblReconcileRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public List<XblReconcileResult> parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<XblReconcileResult>>(){});
    }

    public static SyncXboxInventoryBuilder builder() {
        return new SyncXboxInventoryBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public XblReconcileRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setBody(XblReconcileRequest body) {
        this.body = body;
    }

    public static class SyncXboxInventoryBuilder {
        private String namespace;
        private String userId;
        private XblReconcileRequest body;

        SyncXboxInventoryBuilder() {
        }

        public SyncXboxInventoryBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public SyncXboxInventoryBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public SyncXboxInventoryBuilder body(XblReconcileRequest body) {
            this.body = body;
            return this;
        }

        public SyncXboxInventory build() {
            return new SyncXboxInventory(this.namespace, this.userId, this.body);
        }

        public String toString() {
            return "SyncXboxInventory.SyncXboxInventoryBuilder(namespace=" + this.namespace + ", userId=" + this.userId + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

