/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.fulfillment;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.FulfillmentHistoryPagingSlicedResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class QueryFulfillmentHistories
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/fulfillment/history";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private Integer limit;
    private Integer offset;
    private String status;
    private String userId;

    @Deprecated
    public QueryFulfillmentHistories(String namespace, Integer limit, Integer offset, String status, String userId) {
        this.namespace = namespace;
        this.limit = limit;
        this.offset = offset;
        this.status = status;
        this.userId = userId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("status", this.status == null ? null : Arrays.asList(this.status));
        queryParams.put("userId", this.userId == null ? null : Arrays.asList(this.userId));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public FulfillmentHistoryPagingSlicedResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new FulfillmentHistoryPagingSlicedResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("status", "None");
        result.put("userId", "None");
        return result;
    }

    public static QueryFulfillmentHistoriesBuilder builder() {
        return new QueryFulfillmentHistoriesBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getStatus() {
        return this.status;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public static class QueryFulfillmentHistoriesBuilder {
        private String namespace;
        private Integer limit;
        private Integer offset;
        private String userId;
        private String status;

        public QueryFulfillmentHistoriesBuilder status(String status) {
            this.status = status;
            return this;
        }

        public QueryFulfillmentHistoriesBuilder statusFromEnum(Status status) {
            this.status = status.toString();
            return this;
        }

        QueryFulfillmentHistoriesBuilder() {
        }

        public QueryFulfillmentHistoriesBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public QueryFulfillmentHistoriesBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public QueryFulfillmentHistoriesBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public QueryFulfillmentHistoriesBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public QueryFulfillmentHistories build() {
            return new QueryFulfillmentHistories(this.namespace, this.limit, this.offset, this.status, this.userId);
        }

        public String toString() {
            return "QueryFulfillmentHistories.QueryFulfillmentHistoriesBuilder(namespace=" + this.namespace + ", limit=" + this.limit + ", offset=" + this.offset + ", status=" + this.status + ", userId=" + this.userId + ")";
        }
    }

    public static enum Status {
        FAIL("FAIL"),
        SUCCESS("SUCCESS");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

