/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.entitlement;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.EntitlementInfo;
import net.accelbyte.sdk.api.platform.models.RevokeUseCountRequest;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class RevokeUseCount
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/users/{userId}/entitlements/{entitlementId}/revokeByUseCount";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String entitlementId;
    private String namespace;
    private String userId;
    private RevokeUseCountRequest body;

    @Deprecated
    public RevokeUseCount(String entitlementId, String namespace, String userId, RevokeUseCountRequest body) {
        this.entitlementId = entitlementId;
        this.namespace = namespace;
        this.userId = userId;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.entitlementId != null) {
            pathParams.put("entitlementId", this.entitlementId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public RevokeUseCountRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.entitlementId == null) {
            return false;
        }
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public EntitlementInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new EntitlementInfo().createFromJson(json);
    }

    public static RevokeUseCountBuilder builder() {
        return new RevokeUseCountBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getEntitlementId() {
        return this.entitlementId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public RevokeUseCountRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setEntitlementId(String entitlementId) {
        this.entitlementId = entitlementId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setBody(RevokeUseCountRequest body) {
        this.body = body;
    }

    public static class RevokeUseCountBuilder {
        private String entitlementId;
        private String namespace;
        private String userId;
        private RevokeUseCountRequest body;

        RevokeUseCountBuilder() {
        }

        public RevokeUseCountBuilder entitlementId(String entitlementId) {
            this.entitlementId = entitlementId;
            return this;
        }

        public RevokeUseCountBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public RevokeUseCountBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public RevokeUseCountBuilder body(RevokeUseCountRequest body) {
            this.body = body;
            return this;
        }

        public RevokeUseCount build() {
            return new RevokeUseCount(this.entitlementId, this.namespace, this.userId, this.body);
        }

        public String toString() {
            return "RevokeUseCount.RevokeUseCountBuilder(entitlementId=" + this.entitlementId + ", namespace=" + this.namespace + ", userId=" + this.userId + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

