/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.entitlement;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.EntitlementPagingSlicedResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class QueryEntitlements
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/entitlements";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private Boolean activeOnly;
    private String appType;
    private String entitlementClazz;
    private String entitlementName;
    private List<String> itemId;
    private Integer limit;
    private Integer offset;
    private String userId;

    @Deprecated
    public QueryEntitlements(String namespace, Boolean activeOnly, String appType, String entitlementClazz, String entitlementName, List<String> itemId, Integer limit, Integer offset, String userId) {
        this.namespace = namespace;
        this.activeOnly = activeOnly;
        this.appType = appType;
        this.entitlementClazz = entitlementClazz;
        this.entitlementName = entitlementName;
        this.itemId = itemId;
        this.limit = limit;
        this.offset = offset;
        this.userId = userId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("activeOnly", this.activeOnly == null ? null : Arrays.asList(String.valueOf(this.activeOnly)));
        queryParams.put("appType", this.appType == null ? null : Arrays.asList(this.appType));
        queryParams.put("entitlementClazz", this.entitlementClazz == null ? null : Arrays.asList(this.entitlementClazz));
        queryParams.put("entitlementName", this.entitlementName == null ? null : Arrays.asList(this.entitlementName));
        queryParams.put("itemId", this.itemId == null ? null : this.itemId);
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("userId", this.userId == null ? null : Arrays.asList(this.userId));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public EntitlementPagingSlicedResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new EntitlementPagingSlicedResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("activeOnly", "None");
        result.put("appType", "None");
        result.put("entitlementClazz", "None");
        result.put("entitlementName", "None");
        result.put("itemId", "multi");
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("userId", "None");
        return result;
    }

    public static QueryEntitlementsBuilder builder() {
        return new QueryEntitlementsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Boolean getActiveOnly() {
        return this.activeOnly;
    }

    public String getAppType() {
        return this.appType;
    }

    public String getEntitlementClazz() {
        return this.entitlementClazz;
    }

    public String getEntitlementName() {
        return this.entitlementName;
    }

    public List<String> getItemId() {
        return this.itemId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setActiveOnly(Boolean activeOnly) {
        this.activeOnly = activeOnly;
    }

    public void setAppType(String appType) {
        this.appType = appType;
    }

    public void setEntitlementClazz(String entitlementClazz) {
        this.entitlementClazz = entitlementClazz;
    }

    public void setEntitlementName(String entitlementName) {
        this.entitlementName = entitlementName;
    }

    public void setItemId(List<String> itemId) {
        this.itemId = itemId;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public static class QueryEntitlementsBuilder {
        private String namespace;
        private Boolean activeOnly;
        private String entitlementName;
        private List<String> itemId;
        private Integer limit;
        private Integer offset;
        private String userId;
        private String appType;
        private String entitlementClazz;

        public QueryEntitlementsBuilder appType(String appType) {
            this.appType = appType;
            return this;
        }

        public QueryEntitlementsBuilder appTypeFromEnum(AppType appType) {
            this.appType = appType.toString();
            return this;
        }

        public QueryEntitlementsBuilder entitlementClazz(String entitlementClazz) {
            this.entitlementClazz = entitlementClazz;
            return this;
        }

        public QueryEntitlementsBuilder entitlementClazzFromEnum(EntitlementClazz entitlementClazz) {
            this.entitlementClazz = entitlementClazz.toString();
            return this;
        }

        QueryEntitlementsBuilder() {
        }

        public QueryEntitlementsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public QueryEntitlementsBuilder activeOnly(Boolean activeOnly) {
            this.activeOnly = activeOnly;
            return this;
        }

        public QueryEntitlementsBuilder entitlementName(String entitlementName) {
            this.entitlementName = entitlementName;
            return this;
        }

        public QueryEntitlementsBuilder itemId(List<String> itemId) {
            this.itemId = itemId;
            return this;
        }

        public QueryEntitlementsBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public QueryEntitlementsBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public QueryEntitlementsBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public QueryEntitlements build() {
            return new QueryEntitlements(this.namespace, this.activeOnly, this.appType, this.entitlementClazz, this.entitlementName, this.itemId, this.limit, this.offset, this.userId);
        }

        public String toString() {
            return "QueryEntitlements.QueryEntitlementsBuilder(namespace=" + this.namespace + ", activeOnly=" + this.activeOnly + ", appType=" + this.appType + ", entitlementClazz=" + this.entitlementClazz + ", entitlementName=" + this.entitlementName + ", itemId=" + this.itemId + ", limit=" + this.limit + ", offset=" + this.offset + ", userId=" + this.userId + ")";
        }
    }

    public static enum EntitlementClazz {
        APP("APP"),
        CODE("CODE"),
        ENTITLEMENT("ENTITLEMENT"),
        LOOTBOX("LOOTBOX"),
        MEDIA("MEDIA"),
        OPTIONBOX("OPTIONBOX"),
        SUBSCRIPTION("SUBSCRIPTION");

        private String value;

        private EntitlementClazz(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum AppType {
        DEMO("DEMO"),
        DLC("DLC"),
        GAME("GAME"),
        SOFTWARE("SOFTWARE");

        private String value;

        private AppType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

