/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.entitlement;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.EntitlementInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicGetUserEntitlementBySku
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/users/{userId}/entitlements/bySku";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private String entitlementClazz;
    private String sku;

    @Deprecated
    public PublicGetUserEntitlementBySku(String namespace, String userId, String entitlementClazz, String sku) {
        this.namespace = namespace;
        this.userId = userId;
        this.entitlementClazz = entitlementClazz;
        this.sku = sku;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("entitlementClazz", this.entitlementClazz == null ? null : Arrays.asList(this.entitlementClazz));
        queryParams.put("sku", this.sku == null ? null : Arrays.asList(this.sku));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.userId == null) {
            return false;
        }
        return this.sku != null;
    }

    public EntitlementInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new EntitlementInfo().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("entitlementClazz", "None");
        result.put("sku", "None");
        return result;
    }

    public static PublicGetUserEntitlementBySkuBuilder builder() {
        return new PublicGetUserEntitlementBySkuBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getEntitlementClazz() {
        return this.entitlementClazz;
    }

    public String getSku() {
        return this.sku;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setEntitlementClazz(String entitlementClazz) {
        this.entitlementClazz = entitlementClazz;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public static class PublicGetUserEntitlementBySkuBuilder {
        private String namespace;
        private String userId;
        private String sku;
        private String entitlementClazz;

        public PublicGetUserEntitlementBySkuBuilder entitlementClazz(String entitlementClazz) {
            this.entitlementClazz = entitlementClazz;
            return this;
        }

        public PublicGetUserEntitlementBySkuBuilder entitlementClazzFromEnum(EntitlementClazz entitlementClazz) {
            this.entitlementClazz = entitlementClazz.toString();
            return this;
        }

        PublicGetUserEntitlementBySkuBuilder() {
        }

        public PublicGetUserEntitlementBySkuBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicGetUserEntitlementBySkuBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public PublicGetUserEntitlementBySkuBuilder sku(String sku) {
            this.sku = sku;
            return this;
        }

        public PublicGetUserEntitlementBySku build() {
            return new PublicGetUserEntitlementBySku(this.namespace, this.userId, this.entitlementClazz, this.sku);
        }

        public String toString() {
            return "PublicGetUserEntitlementBySku.PublicGetUserEntitlementBySkuBuilder(namespace=" + this.namespace + ", userId=" + this.userId + ", entitlementClazz=" + this.entitlementClazz + ", sku=" + this.sku + ")";
        }
    }

    public static enum EntitlementClazz {
        APP("APP"),
        CODE("CODE"),
        ENTITLEMENT("ENTITLEMENT"),
        LOOTBOX("LOOTBOX"),
        MEDIA("MEDIA"),
        OPTIONBOX("OPTIONBOX"),
        SUBSCRIPTION("SUBSCRIPTION");

        private String value;

        private EntitlementClazz(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

