/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.entitlement;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.AppEntitlementInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class GetUserAppEntitlementByAppId
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/users/{userId}/entitlements/byAppId";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private Boolean activeOnly;
    private String appId;

    @Deprecated
    public GetUserAppEntitlementByAppId(String namespace, String userId, Boolean activeOnly, String appId) {
        this.namespace = namespace;
        this.userId = userId;
        this.activeOnly = activeOnly;
        this.appId = appId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("activeOnly", this.activeOnly == null ? null : Arrays.asList(String.valueOf(this.activeOnly)));
        queryParams.put("appId", this.appId == null ? null : Arrays.asList(this.appId));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.userId == null) {
            return false;
        }
        return this.appId != null;
    }

    public AppEntitlementInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new AppEntitlementInfo().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("activeOnly", "None");
        result.put("appId", "None");
        return result;
    }

    public static GetUserAppEntitlementByAppIdBuilder builder() {
        return new GetUserAppEntitlementByAppIdBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public Boolean getActiveOnly() {
        return this.activeOnly;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setActiveOnly(Boolean activeOnly) {
        this.activeOnly = activeOnly;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public static class GetUserAppEntitlementByAppIdBuilder {
        private String namespace;
        private String userId;
        private Boolean activeOnly;
        private String appId;

        GetUserAppEntitlementByAppIdBuilder() {
        }

        public GetUserAppEntitlementByAppIdBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GetUserAppEntitlementByAppIdBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public GetUserAppEntitlementByAppIdBuilder activeOnly(Boolean activeOnly) {
            this.activeOnly = activeOnly;
            return this;
        }

        public GetUserAppEntitlementByAppIdBuilder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public GetUserAppEntitlementByAppId build() {
            return new GetUserAppEntitlementByAppId(this.namespace, this.userId, this.activeOnly, this.appId);
        }

        public String toString() {
            return "GetUserAppEntitlementByAppId.GetUserAppEntitlementByAppIdBuilder(namespace=" + this.namespace + ", userId=" + this.userId + ", activeOnly=" + this.activeOnly + ", appId=" + this.appId + ")";
        }
    }
}

