/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.dlc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.DLCConfigRewardShortInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class GeDLCDurableRewardShortMap
extends Operation {
    private String path = "/platform/public/namespaces/{namespace}/dlc/rewards/durable/map";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList(new String[0]);
    private String locationQuery = null;
    private String namespace;
    private String dlcType;

    @Deprecated
    public GeDLCDurableRewardShortMap(String namespace, String dlcType) {
        this.namespace = namespace;
        this.dlcType = dlcType;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("dlcType", this.dlcType == null ? null : Arrays.asList(this.dlcType));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.dlcType != null;
    }

    public DLCConfigRewardShortInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new DLCConfigRewardShortInfo().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("dlcType", "None");
        return result;
    }

    public static GeDLCDurableRewardShortMapBuilder builder() {
        return new GeDLCDurableRewardShortMapBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getDlcType() {
        return this.dlcType;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setDlcType(String dlcType) {
        this.dlcType = dlcType;
    }

    public static class GeDLCDurableRewardShortMapBuilder {
        private String namespace;
        private String dlcType;

        public GeDLCDurableRewardShortMapBuilder dlcType(String dlcType) {
            this.dlcType = dlcType;
            return this;
        }

        public GeDLCDurableRewardShortMapBuilder dlcTypeFromEnum(DlcType dlcType) {
            this.dlcType = dlcType.toString();
            return this;
        }

        GeDLCDurableRewardShortMapBuilder() {
        }

        public GeDLCDurableRewardShortMapBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GeDLCDurableRewardShortMap build() {
            return new GeDLCDurableRewardShortMap(this.namespace, this.dlcType);
        }

        public String toString() {
            return "GeDLCDurableRewardShortMap.GeDLCDurableRewardShortMapBuilder(namespace=" + this.namespace + ", dlcType=" + this.dlcType + ")";
        }
    }

    public static enum DlcType {
        EPICGAMES("EPICGAMES"),
        OCULUS("OCULUS"),
        PSN("PSN"),
        STEAM("STEAM"),
        XBOX("XBOX");

        private String value;

        private DlcType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

