/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.currency;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.CurrencyInfo;
import net.accelbyte.sdk.api.platform.models.CurrencyUpdate;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class UpdateCurrency
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/currencies/{currencyCode}";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String currencyCode;
    private String namespace;
    private CurrencyUpdate body;

    @Deprecated
    public UpdateCurrency(String currencyCode, String namespace, CurrencyUpdate body) {
        this.currencyCode = currencyCode;
        this.namespace = namespace;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.currencyCode != null) {
            pathParams.put("currencyCode", this.currencyCode);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public CurrencyUpdate getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.currencyCode == null) {
            return false;
        }
        return this.namespace != null;
    }

    public CurrencyInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new CurrencyInfo().createFromJson(json);
    }

    public static UpdateCurrencyBuilder builder() {
        return new UpdateCurrencyBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public CurrencyUpdate getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBody(CurrencyUpdate body) {
        this.body = body;
    }

    public static class UpdateCurrencyBuilder {
        private String currencyCode;
        private String namespace;
        private CurrencyUpdate body;

        UpdateCurrencyBuilder() {
        }

        public UpdateCurrencyBuilder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public UpdateCurrencyBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public UpdateCurrencyBuilder body(CurrencyUpdate body) {
            this.body = body;
            return this;
        }

        public UpdateCurrency build() {
            return new UpdateCurrency(this.currencyCode, this.namespace, this.body);
        }

        public String toString() {
            return "UpdateCurrency.UpdateCurrencyBuilder(currencyCode=" + this.currencyCode + ", namespace=" + this.namespace + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

