/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.currency;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.CurrencyConfig;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class GetCurrencyConfig
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/currencies/{currencyCode}/config";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String currencyCode;
    private String namespace;

    @Deprecated
    public GetCurrencyConfig(String currencyCode, String namespace) {
        this.currencyCode = currencyCode;
        this.namespace = namespace;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.currencyCode != null) {
            pathParams.put("currencyCode", this.currencyCode);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.currencyCode == null) {
            return false;
        }
        return this.namespace != null;
    }

    public CurrencyConfig parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new CurrencyConfig().createFromJson(json);
    }

    public static GetCurrencyConfigBuilder builder() {
        return new GetCurrencyConfigBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public static class GetCurrencyConfigBuilder {
        private String currencyCode;
        private String namespace;

        GetCurrencyConfigBuilder() {
        }

        public GetCurrencyConfigBuilder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public GetCurrencyConfigBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GetCurrencyConfig build() {
            return new GetCurrencyConfig(this.currencyCode, this.namespace);
        }

        public String toString() {
            return "GetCurrencyConfig.GetCurrencyConfigBuilder(currencyCode=" + this.currencyCode + ", namespace=" + this.namespace + ")";
        }
    }
}

