/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.campaign;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.CampaignInfo;
import net.accelbyte.sdk.api.platform.models.CampaignUpdate;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class UpdateCampaign
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/campaigns/{campaignId}";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String campaignId;
    private String namespace;
    private CampaignUpdate body;

    @Deprecated
    public UpdateCampaign(String campaignId, String namespace, CampaignUpdate body) {
        this.campaignId = campaignId;
        this.namespace = namespace;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.campaignId != null) {
            pathParams.put("campaignId", this.campaignId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public CampaignUpdate getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.campaignId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public CampaignInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new CampaignInfo().createFromJson(json);
    }

    public static UpdateCampaignBuilder builder() {
        return new UpdateCampaignBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public CampaignUpdate getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBody(CampaignUpdate body) {
        this.body = body;
    }

    public static class UpdateCampaignBuilder {
        private String campaignId;
        private String namespace;
        private CampaignUpdate body;

        UpdateCampaignBuilder() {
        }

        public UpdateCampaignBuilder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public UpdateCampaignBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public UpdateCampaignBuilder body(CampaignUpdate body) {
            this.body = body;
            return this;
        }

        public UpdateCampaign build() {
            return new UpdateCampaign(this.campaignId, this.namespace, this.body);
        }

        public String toString() {
            return "UpdateCampaign.UpdateCampaignBuilder(campaignId=" + this.campaignId + ", namespace=" + this.namespace + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

