/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.campaign;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.RedeemHistoryPagingSlicedResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class QueryRedeemHistory
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/codes/campaigns/{campaignId}/history";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String campaignId;
    private String namespace;
    private String code;
    private Integer limit;
    private Integer offset;
    private String userId;

    @Deprecated
    public QueryRedeemHistory(String campaignId, String namespace, String code, Integer limit, Integer offset, String userId) {
        this.campaignId = campaignId;
        this.namespace = namespace;
        this.code = code;
        this.limit = limit;
        this.offset = offset;
        this.userId = userId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.campaignId != null) {
            pathParams.put("campaignId", this.campaignId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("code", this.code == null ? null : Arrays.asList(this.code));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("userId", this.userId == null ? null : Arrays.asList(this.userId));
        return queryParams;
    }

    public boolean isValid() {
        if (this.campaignId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public RedeemHistoryPagingSlicedResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new RedeemHistoryPagingSlicedResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("code", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("userId", "None");
        return result;
    }

    public static QueryRedeemHistoryBuilder builder() {
        return new QueryRedeemHistoryBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getCode() {
        return this.code;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public static class QueryRedeemHistoryBuilder {
        private String campaignId;
        private String namespace;
        private String code;
        private Integer limit;
        private Integer offset;
        private String userId;

        QueryRedeemHistoryBuilder() {
        }

        public QueryRedeemHistoryBuilder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public QueryRedeemHistoryBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public QueryRedeemHistoryBuilder code(String code) {
            this.code = code;
            return this;
        }

        public QueryRedeemHistoryBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public QueryRedeemHistoryBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public QueryRedeemHistoryBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public QueryRedeemHistory build() {
            return new QueryRedeemHistory(this.campaignId, this.namespace, this.code, this.limit, this.offset, this.userId);
        }

        public String toString() {
            return "QueryRedeemHistory.QueryRedeemHistoryBuilder(campaignId=" + this.campaignId + ", namespace=" + this.namespace + ", code=" + this.code + ", limit=" + this.limit + ", offset=" + this.offset + ", userId=" + this.userId + ")";
        }
    }
}

