/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.campaign;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.CodeInfoPagingSlicedResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class QueryCodes
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/codes/campaigns/{campaignId}";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String campaignId;
    private String namespace;
    private Boolean activeOnly;
    private Integer batchNo;
    private String code;
    private Integer limit;
    private Integer offset;

    @Deprecated
    public QueryCodes(String campaignId, String namespace, Boolean activeOnly, Integer batchNo, String code, Integer limit, Integer offset) {
        this.campaignId = campaignId;
        this.namespace = namespace;
        this.activeOnly = activeOnly;
        this.batchNo = batchNo;
        this.code = code;
        this.limit = limit;
        this.offset = offset;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.campaignId != null) {
            pathParams.put("campaignId", this.campaignId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("activeOnly", this.activeOnly == null ? null : Arrays.asList(String.valueOf(this.activeOnly)));
        queryParams.put("batchNo", this.batchNo == null ? null : Arrays.asList(String.valueOf(this.batchNo)));
        queryParams.put("code", this.code == null ? null : Arrays.asList(this.code));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        return queryParams;
    }

    public boolean isValid() {
        if (this.campaignId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public CodeInfoPagingSlicedResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new CodeInfoPagingSlicedResult().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("activeOnly", "None");
        result.put("batchNo", "None");
        result.put("code", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        return result;
    }

    public static QueryCodesBuilder builder() {
        return new QueryCodesBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Boolean getActiveOnly() {
        return this.activeOnly;
    }

    public Integer getBatchNo() {
        return this.batchNo;
    }

    public String getCode() {
        return this.code;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setActiveOnly(Boolean activeOnly) {
        this.activeOnly = activeOnly;
    }

    public void setBatchNo(Integer batchNo) {
        this.batchNo = batchNo;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public static class QueryCodesBuilder {
        private String campaignId;
        private String namespace;
        private Boolean activeOnly;
        private Integer batchNo;
        private String code;
        private Integer limit;
        private Integer offset;

        QueryCodesBuilder() {
        }

        public QueryCodesBuilder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public QueryCodesBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public QueryCodesBuilder activeOnly(Boolean activeOnly) {
            this.activeOnly = activeOnly;
            return this;
        }

        public QueryCodesBuilder batchNo(Integer batchNo) {
            this.batchNo = batchNo;
            return this;
        }

        public QueryCodesBuilder code(String code) {
            this.code = code;
            return this;
        }

        public QueryCodesBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public QueryCodesBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public QueryCodes build() {
            return new QueryCodes(this.campaignId, this.namespace, this.activeOnly, this.batchNo, this.code, this.limit, this.offset);
        }

        public String toString() {
            return "QueryCodes.QueryCodesBuilder(campaignId=" + this.campaignId + ", namespace=" + this.namespace + ", activeOnly=" + this.activeOnly + ", batchNo=" + this.batchNo + ", code=" + this.code + ", limit=" + this.limit + ", offset=" + this.offset + ")";
        }
    }
}

