/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.campaign;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.CampaignDynamicInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class GetCampaignDynamic
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/campaigns/{campaignId}/dynamic";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String campaignId;
    private String namespace;

    @Deprecated
    public GetCampaignDynamic(String campaignId, String namespace) {
        this.campaignId = campaignId;
        this.namespace = namespace;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.campaignId != null) {
            pathParams.put("campaignId", this.campaignId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.campaignId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public CampaignDynamicInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new CampaignDynamicInfo().createFromJson(json);
    }

    public static GetCampaignDynamicBuilder builder() {
        return new GetCampaignDynamicBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public static class GetCampaignDynamicBuilder {
        private String campaignId;
        private String namespace;

        GetCampaignDynamicBuilder() {
        }

        public GetCampaignDynamicBuilder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public GetCampaignDynamicBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GetCampaignDynamic build() {
            return new GetCampaignDynamic(this.campaignId, this.namespace);
        }

        public String toString() {
            return "GetCampaignDynamic.GetCampaignDynamicBuilder(campaignId=" + this.campaignId + ", namespace=" + this.namespace + ")";
        }
    }
}

