/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.operations.achievement_platform;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.XblUserAchievements;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class GetXblUserAchievements
extends Operation {
    private String path = "/platform/admin/namespaces/{namespace}/users/{userId}/achievement/xbl";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private String xboxUserId;

    @Deprecated
    public GetXblUserAchievements(String namespace, String userId, String xboxUserId) {
        this.namespace = namespace;
        this.userId = userId;
        this.xboxUserId = xboxUserId;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("xboxUserId", this.xboxUserId == null ? null : Arrays.asList(this.xboxUserId));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.userId == null) {
            return false;
        }
        return this.xboxUserId != null;
    }

    public XblUserAchievements parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new XblUserAchievements().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("xboxUserId", "None");
        return result;
    }

    public static GetXblUserAchievementsBuilder builder() {
        return new GetXblUserAchievementsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getXboxUserId() {
        return this.xboxUserId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setXboxUserId(String xboxUserId) {
        this.xboxUserId = xboxUserId;
    }

    public static class GetXblUserAchievementsBuilder {
        private String namespace;
        private String userId;
        private String xboxUserId;

        GetXblUserAchievementsBuilder() {
        }

        public GetXblUserAchievementsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GetXblUserAchievementsBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public GetXblUserAchievementsBuilder xboxUserId(String xboxUserId) {
            this.xboxUserId = xboxUserId;
            return this;
        }

        public GetXblUserAchievements build() {
            return new GetXblUserAchievements(this.namespace, this.userId, this.xboxUserId);
        }

        public String toString() {
            return "GetXblUserAchievements.GetXblUserAchievementsBuilder(namespace=" + this.namespace + ", userId=" + this.userId + ", xboxUserId=" + this.xboxUserId + ")";
        }
    }
}

