/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.platform.models.PlatformReward;
import net.accelbyte.sdk.api.platform.models.RevocationResult;
import net.accelbyte.sdk.api.platform.models.RevokeResult;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UserDLCRecord
extends Model {
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String id;
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, ?> metadata;
    @JsonProperty(value="namespace")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String namespace;
    @JsonProperty(value="obtainedAt")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String obtainedAt;
    @JsonProperty(value="platform")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String platform;
    @JsonProperty(value="revocationResult")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private RevocationResult revocationResult;
    @JsonProperty(value="revokeResults")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<RevokeResult> revokeResults;
    @JsonProperty(value="revokedAt")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String revokedAt;
    @JsonProperty(value="rewards")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<PlatformReward> rewards;
    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<String> sources;
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String status;
    @JsonProperty(value="transactionId")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String transactionId;
    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String userId;
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer version;

    @JsonIgnore
    public String getPlatform() {
        return this.platform;
    }

    @JsonIgnore
    public Platform getPlatformAsEnum() {
        return Platform.valueOf(this.platform);
    }

    @JsonIgnore
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @JsonIgnore
    public void setPlatformFromEnum(Platform platform) {
        this.platform = platform.toString();
    }

    @JsonIgnore
    public String getStatus() {
        return this.status;
    }

    @JsonIgnore
    public Status getStatusAsEnum() {
        return Status.valueOf(this.status);
    }

    @JsonIgnore
    public void setStatus(String status) {
        this.status = status;
    }

    @JsonIgnore
    public void setStatusFromEnum(Status status) {
        this.status = status.toString();
    }

    @JsonIgnore
    public UserDLCRecord createFromJson(String json) throws JsonProcessingException {
        return (UserDLCRecord)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<UserDLCRecord> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<UserDLCRecord>>(){});
    }

    public static UserDLCRecordBuilder builder() {
        return new UserDLCRecordBuilder();
    }

    public String getId() {
        return this.id;
    }

    public Map<String, ?> getMetadata() {
        return this.metadata;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getObtainedAt() {
        return this.obtainedAt;
    }

    public RevocationResult getRevocationResult() {
        return this.revocationResult;
    }

    public List<RevokeResult> getRevokeResults() {
        return this.revokeResults;
    }

    public String getRevokedAt() {
        return this.revokedAt;
    }

    public List<PlatformReward> getRewards() {
        return this.rewards;
    }

    public List<String> getSources() {
        return this.sources;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Map<String, ?> metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @JsonProperty(value="obtainedAt")
    public void setObtainedAt(String obtainedAt) {
        this.obtainedAt = obtainedAt;
    }

    @JsonProperty(value="revocationResult")
    public void setRevocationResult(RevocationResult revocationResult) {
        this.revocationResult = revocationResult;
    }

    @JsonProperty(value="revokeResults")
    public void setRevokeResults(List<RevokeResult> revokeResults) {
        this.revokeResults = revokeResults;
    }

    @JsonProperty(value="revokedAt")
    public void setRevokedAt(String revokedAt) {
        this.revokedAt = revokedAt;
    }

    @JsonProperty(value="rewards")
    public void setRewards(List<PlatformReward> rewards) {
        this.rewards = rewards;
    }

    @JsonProperty(value="sources")
    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    @JsonProperty(value="transactionId")
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    @JsonProperty(value="userId")
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @JsonProperty(value="version")
    public void setVersion(Integer version) {
        this.version = version;
    }

    @Deprecated
    public UserDLCRecord(String id, Map<String, ?> metadata, String namespace, String obtainedAt, String platform, RevocationResult revocationResult, List<RevokeResult> revokeResults, String revokedAt, List<PlatformReward> rewards, List<String> sources, String status, String transactionId, String userId, Integer version) {
        this.id = id;
        this.metadata = metadata;
        this.namespace = namespace;
        this.obtainedAt = obtainedAt;
        this.platform = platform;
        this.revocationResult = revocationResult;
        this.revokeResults = revokeResults;
        this.revokedAt = revokedAt;
        this.rewards = rewards;
        this.sources = sources;
        this.status = status;
        this.transactionId = transactionId;
        this.userId = userId;
        this.version = version;
    }

    public UserDLCRecord() {
    }

    public static class UserDLCRecordBuilder {
        private String id;
        private Map<String, ?> metadata;
        private String namespace;
        private String obtainedAt;
        private RevocationResult revocationResult;
        private List<RevokeResult> revokeResults;
        private String revokedAt;
        private List<PlatformReward> rewards;
        private List<String> sources;
        private String transactionId;
        private String userId;
        private Integer version;
        private String platform;
        private String status;

        public UserDLCRecordBuilder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public UserDLCRecordBuilder platformFromEnum(Platform platform) {
            this.platform = platform.toString();
            return this;
        }

        public UserDLCRecordBuilder status(String status) {
            this.status = status;
            return this;
        }

        public UserDLCRecordBuilder statusFromEnum(Status status) {
            this.status = status.toString();
            return this;
        }

        UserDLCRecordBuilder() {
        }

        @JsonProperty(value="id")
        public UserDLCRecordBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="metadata")
        public UserDLCRecordBuilder metadata(Map<String, ?> metadata) {
            this.metadata = metadata;
            return this;
        }

        @JsonProperty(value="namespace")
        public UserDLCRecordBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @JsonProperty(value="obtainedAt")
        public UserDLCRecordBuilder obtainedAt(String obtainedAt) {
            this.obtainedAt = obtainedAt;
            return this;
        }

        @JsonProperty(value="revocationResult")
        public UserDLCRecordBuilder revocationResult(RevocationResult revocationResult) {
            this.revocationResult = revocationResult;
            return this;
        }

        @JsonProperty(value="revokeResults")
        public UserDLCRecordBuilder revokeResults(List<RevokeResult> revokeResults) {
            this.revokeResults = revokeResults;
            return this;
        }

        @JsonProperty(value="revokedAt")
        public UserDLCRecordBuilder revokedAt(String revokedAt) {
            this.revokedAt = revokedAt;
            return this;
        }

        @JsonProperty(value="rewards")
        public UserDLCRecordBuilder rewards(List<PlatformReward> rewards) {
            this.rewards = rewards;
            return this;
        }

        @JsonProperty(value="sources")
        public UserDLCRecordBuilder sources(List<String> sources) {
            this.sources = sources;
            return this;
        }

        @JsonProperty(value="transactionId")
        public UserDLCRecordBuilder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        @JsonProperty(value="userId")
        public UserDLCRecordBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @JsonProperty(value="version")
        public UserDLCRecordBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public UserDLCRecord build() {
            return new UserDLCRecord(this.id, this.metadata, this.namespace, this.obtainedAt, this.platform, this.revocationResult, this.revokeResults, this.revokedAt, this.rewards, this.sources, this.status, this.transactionId, this.userId, this.version);
        }

        public String toString() {
            return "UserDLCRecord.UserDLCRecordBuilder(id=" + this.id + ", metadata=" + this.metadata + ", namespace=" + this.namespace + ", obtainedAt=" + this.obtainedAt + ", platform=" + this.platform + ", revocationResult=" + (Object)((Object)this.revocationResult) + ", revokeResults=" + this.revokeResults + ", revokedAt=" + this.revokedAt + ", rewards=" + this.rewards + ", sources=" + this.sources + ", status=" + this.status + ", transactionId=" + this.transactionId + ", userId=" + this.userId + ", version=" + this.version + ")";
        }
    }

    public static enum Status {
        FULFILLED("FULFILLED"),
        REVOKED("REVOKED"),
        REVOKEFAILED("REVOKE_FAILED");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Platform {
        EPICGAMES("EPICGAMES"),
        OCULUS("OCULUS"),
        PSN("PSN"),
        STEAM("STEAM"),
        XBOX("XBOX");

        private String value;

        private Platform(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

