/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Slide
extends Model {
    @JsonProperty(value="alt")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String alt;
    @JsonProperty(value="previewUrl")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String previewUrl;
    @JsonProperty(value="thumbnailUrl")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String thumbnailUrl;
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String type;
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String url;
    @JsonProperty(value="videoSource")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String videoSource;

    @JsonIgnore
    public String getType() {
        return this.type;
    }

    @JsonIgnore
    public Type getTypeAsEnum() {
        return Type.valueOf(this.type);
    }

    @JsonIgnore
    public void setType(String type) {
        this.type = type;
    }

    @JsonIgnore
    public void setTypeFromEnum(Type type) {
        this.type = type.toString();
    }

    @JsonIgnore
    public String getVideoSource() {
        return this.videoSource;
    }

    @JsonIgnore
    public VideoSource getVideoSourceAsEnum() {
        return VideoSource.valueOf(this.videoSource);
    }

    @JsonIgnore
    public void setVideoSource(String videoSource) {
        this.videoSource = videoSource;
    }

    @JsonIgnore
    public void setVideoSourceFromEnum(VideoSource videoSource) {
        this.videoSource = videoSource.toString();
    }

    @JsonIgnore
    public Slide createFromJson(String json) throws JsonProcessingException {
        return (Slide)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<Slide> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<Slide>>(){});
    }

    public static SlideBuilder builder() {
        return new SlideBuilder();
    }

    public String getAlt() {
        return this.alt;
    }

    public String getPreviewUrl() {
        return this.previewUrl;
    }

    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="alt")
    public void setAlt(String alt) {
        this.alt = alt;
    }

    @JsonProperty(value="previewUrl")
    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    @JsonProperty(value="thumbnailUrl")
    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    @Deprecated
    public Slide(String alt, String previewUrl, String thumbnailUrl, String type, String url, String videoSource) {
        this.alt = alt;
        this.previewUrl = previewUrl;
        this.thumbnailUrl = thumbnailUrl;
        this.type = type;
        this.url = url;
        this.videoSource = videoSource;
    }

    public Slide() {
    }

    public static class SlideBuilder {
        private String alt;
        private String previewUrl;
        private String thumbnailUrl;
        private String url;
        private String type;
        private String videoSource;

        public SlideBuilder type(String type) {
            this.type = type;
            return this;
        }

        public SlideBuilder typeFromEnum(Type type) {
            this.type = type.toString();
            return this;
        }

        public SlideBuilder videoSource(String videoSource) {
            this.videoSource = videoSource;
            return this;
        }

        public SlideBuilder videoSourceFromEnum(VideoSource videoSource) {
            this.videoSource = videoSource.toString();
            return this;
        }

        SlideBuilder() {
        }

        @JsonProperty(value="alt")
        public SlideBuilder alt(String alt) {
            this.alt = alt;
            return this;
        }

        @JsonProperty(value="previewUrl")
        public SlideBuilder previewUrl(String previewUrl) {
            this.previewUrl = previewUrl;
            return this;
        }

        @JsonProperty(value="thumbnailUrl")
        public SlideBuilder thumbnailUrl(String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
            return this;
        }

        @JsonProperty(value="url")
        public SlideBuilder url(String url) {
            this.url = url;
            return this;
        }

        public Slide build() {
            return new Slide(this.alt, this.previewUrl, this.thumbnailUrl, this.type, this.url, this.videoSource);
        }

        public String toString() {
            return "Slide.SlideBuilder(alt=" + this.alt + ", previewUrl=" + this.previewUrl + ", thumbnailUrl=" + this.thumbnailUrl + ", type=" + this.type + ", url=" + this.url + ", videoSource=" + this.videoSource + ")";
        }
    }

    public static enum VideoSource {
        Generic("generic"),
        Vimeo("vimeo"),
        Youtube("youtube");

        private String value;

        private VideoSource(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Type {
        Image("image"),
        Video("video");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

