/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RevokeItem
extends Model {
    @JsonProperty(value="itemIdentity")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String itemIdentity;
    @JsonProperty(value="itemIdentityType")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String itemIdentityType;
    @JsonProperty(value="origin")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String origin;

    @JsonIgnore
    public String getItemIdentityType() {
        return this.itemIdentityType;
    }

    @JsonIgnore
    public ItemIdentityType getItemIdentityTypeAsEnum() {
        return ItemIdentityType.valueOf(this.itemIdentityType);
    }

    @JsonIgnore
    public void setItemIdentityType(String itemIdentityType) {
        this.itemIdentityType = itemIdentityType;
    }

    @JsonIgnore
    public void setItemIdentityTypeFromEnum(ItemIdentityType itemIdentityType) {
        this.itemIdentityType = itemIdentityType.toString();
    }

    @JsonIgnore
    public String getOrigin() {
        return this.origin;
    }

    @JsonIgnore
    public Origin getOriginAsEnum() {
        return Origin.valueOf(this.origin);
    }

    @JsonIgnore
    public void setOrigin(String origin) {
        this.origin = origin;
    }

    @JsonIgnore
    public void setOriginFromEnum(Origin origin) {
        this.origin = origin.toString();
    }

    @JsonIgnore
    public RevokeItem createFromJson(String json) throws JsonProcessingException {
        return (RevokeItem)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<RevokeItem> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<RevokeItem>>(){});
    }

    public static RevokeItemBuilder builder() {
        return new RevokeItemBuilder();
    }

    public String getItemIdentity() {
        return this.itemIdentity;
    }

    @JsonProperty(value="itemIdentity")
    public void setItemIdentity(String itemIdentity) {
        this.itemIdentity = itemIdentity;
    }

    @Deprecated
    public RevokeItem(String itemIdentity, String itemIdentityType, String origin) {
        this.itemIdentity = itemIdentity;
        this.itemIdentityType = itemIdentityType;
        this.origin = origin;
    }

    public RevokeItem() {
    }

    public static class RevokeItemBuilder {
        private String itemIdentity;
        private String itemIdentityType;
        private String origin;

        public RevokeItemBuilder itemIdentityType(String itemIdentityType) {
            this.itemIdentityType = itemIdentityType;
            return this;
        }

        public RevokeItemBuilder itemIdentityTypeFromEnum(ItemIdentityType itemIdentityType) {
            this.itemIdentityType = itemIdentityType.toString();
            return this;
        }

        public RevokeItemBuilder origin(String origin) {
            this.origin = origin;
            return this;
        }

        public RevokeItemBuilder originFromEnum(Origin origin) {
            this.origin = origin.toString();
            return this;
        }

        RevokeItemBuilder() {
        }

        @JsonProperty(value="itemIdentity")
        public RevokeItemBuilder itemIdentity(String itemIdentity) {
            this.itemIdentity = itemIdentity;
            return this;
        }

        public RevokeItem build() {
            return new RevokeItem(this.itemIdentity, this.itemIdentityType, this.origin);
        }

        public String toString() {
            return "RevokeItem.RevokeItemBuilder(itemIdentity=" + this.itemIdentity + ", itemIdentityType=" + this.itemIdentityType + ", origin=" + this.origin + ")";
        }
    }

    public static enum Origin {
        Epic("Epic"),
        GooglePlay("GooglePlay"),
        IOS("IOS"),
        Nintendo("Nintendo"),
        Oculus("Oculus"),
        Other("Other"),
        Playstation("Playstation"),
        Steam("Steam"),
        System("System"),
        Twitch("Twitch"),
        Xbox("Xbox");

        private String value;

        private Origin(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum ItemIdentityType {
        ITEMID("ITEM_ID"),
        ITEMSKU("ITEM_SKU");

        private String value;

        private ItemIdentityType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

