/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.platform.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.api.platform.models.RevokeCurrency;
import net.accelbyte.sdk.api.platform.models.RevokeEntitlement;
import net.accelbyte.sdk.api.platform.models.RevokeItem;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RevokeEntry
extends Model {
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private RevokeCurrency currency;
    @JsonProperty(value="entitlement")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private RevokeEntitlement entitlement;
    @JsonProperty(value="item")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private RevokeItem item;
    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer quantity;
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String type;

    @JsonIgnore
    public String getType() {
        return this.type;
    }

    @JsonIgnore
    public Type getTypeAsEnum() {
        return Type.valueOf(this.type);
    }

    @JsonIgnore
    public void setType(String type) {
        this.type = type;
    }

    @JsonIgnore
    public void setTypeFromEnum(Type type) {
        this.type = type.toString();
    }

    @JsonIgnore
    public RevokeEntry createFromJson(String json) throws JsonProcessingException {
        return (RevokeEntry)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<RevokeEntry> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<RevokeEntry>>(){});
    }

    public static RevokeEntryBuilder builder() {
        return new RevokeEntryBuilder();
    }

    public RevokeCurrency getCurrency() {
        return this.currency;
    }

    public RevokeEntitlement getEntitlement() {
        return this.entitlement;
    }

    public RevokeItem getItem() {
        return this.item;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="currency")
    public void setCurrency(RevokeCurrency currency) {
        this.currency = currency;
    }

    @JsonProperty(value="entitlement")
    public void setEntitlement(RevokeEntitlement entitlement) {
        this.entitlement = entitlement;
    }

    @JsonProperty(value="item")
    public void setItem(RevokeItem item) {
        this.item = item;
    }

    @JsonProperty(value="quantity")
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    @Deprecated
    public RevokeEntry(RevokeCurrency currency, RevokeEntitlement entitlement, RevokeItem item, Integer quantity, String type) {
        this.currency = currency;
        this.entitlement = entitlement;
        this.item = item;
        this.quantity = quantity;
        this.type = type;
    }

    public RevokeEntry() {
    }

    public static class RevokeEntryBuilder {
        private RevokeCurrency currency;
        private RevokeEntitlement entitlement;
        private RevokeItem item;
        private Integer quantity;
        private String type;

        public RevokeEntryBuilder type(String type) {
            this.type = type;
            return this;
        }

        public RevokeEntryBuilder typeFromEnum(Type type) {
            this.type = type.toString();
            return this;
        }

        RevokeEntryBuilder() {
        }

        @JsonProperty(value="currency")
        public RevokeEntryBuilder currency(RevokeCurrency currency) {
            this.currency = currency;
            return this;
        }

        @JsonProperty(value="entitlement")
        public RevokeEntryBuilder entitlement(RevokeEntitlement entitlement) {
            this.entitlement = entitlement;
            return this;
        }

        @JsonProperty(value="item")
        public RevokeEntryBuilder item(RevokeItem item) {
            this.item = item;
            return this;
        }

        @JsonProperty(value="quantity")
        public RevokeEntryBuilder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public RevokeEntry build() {
            return new RevokeEntry(this.currency, this.entitlement, this.item, this.quantity, this.type);
        }

        public String toString() {
            return "RevokeEntry.RevokeEntryBuilder(currency=" + (Object)((Object)this.currency) + ", entitlement=" + (Object)((Object)this.entitlement) + ", item=" + (Object)((Object)this.item) + ", quantity=" + this.quantity + ", type=" + this.type + ")";
        }
    }

    public static enum Type {
        CURRENCY("CURRENCY"),
        ENTITLEMENT("ENTITLEMENT"),
        ITEM("ITEM");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

